<?php
class DomainAvailability {

	/**
	 * This function checks if the supplied domain name is registered
	 * @param string $domain The domain that will be checked for registration.
	 * @return boolean true means the domain is NOT registered
	 */
	public function is_available($domain) {

		// make the domain lowercase
		$domain = strtolower($domain);

		// Set the timeout (in seconds) for the socket open function.
		$timeout = 10;

		/**
		 * This array contains the list of WHOIS servers and the "domain not found" string
		 * to be searched for to check if the domain is available for registration.
		 *
		 * NOTE: The "domain not found" string may change at any time for any reason.
		 */
		 $whois_arr = array(
			'aarp' => array('whois.nic.aarp', 'no match'),
			'abarth' => array('whois.afilias-srs.net', 'not found'),
			'abbott' => array('whois.afilias-srs.net', 'not found'),
			'abbvie' => array('whois.afilias-srs.net', 'not found'),
			'abc' => array('whois.nic.abc', 'no match'),
			'abogado' => array('whois.nic.abogado', 'this domain name has not been registered'),
			'abudhabi' => array('whois.nic.abudhabi', 'No Data Found'),
			'ac' => array('whois.nic.ac', 'not found'),
			'co.ac' => array('whois.nic.ac', 'not found'),
			'gv.ac' => array('whois.nic.ac', 'not found'),
			'or.ac' => array('whois.nic.ac', 'not found'),
			'academy' => array('whois.donuts.co', 'domain not found'),
			'accountant' => array('whois.nic.accountant', 'No Data Found'),
			'accountants' => array('whois.donuts.co', 'domain not found.'),
			'aco' => array('whois.afilias-srs.net', 'not found'),
			'actor' => array('whois.donuts.co', 'domain not found.'),
			'ad' => array('whois.ripe.net', 'no entries found'),
			'ads' => array('whois.nic.google', 'domain not found'),
			'adult' => array('whois.afilias-srs.net', 'not found'),
			'ae' => array('whois-check.aeda.net.ae', 'available'),
			'aeg' => array('whois.nic.aeg', 'no match'),
			'aero' => array('whois.aero', 'not found'),
			'af' => array('whois.nic.af', 'no object found'),
			'afl' => array('whois.nic.afl', 'No Data Found'),
			'africa' => array('whois.nic.africa', 'available'),
			'ag' => array('whois.nic.ag', 'not found'),
			'agakhan' => array('whois.afilias-srs.net', 'not found'),
			'agency' => array('whois.donuts.co', 'domain not found.'),
			'ai' => array('whois.nic.ai', 'no object found'),
			'aigo' => array('whois.afilias-srs.net', 'not found'),
			'airbus' => array('whois.nic.airbus', 'no match'),
			'airforce' => array('whois.nic.airforce', 'domain not found.'),
			'airtel' => array('whois.nic.airtel', 'no match'),
			'akdn' => array('whois.afilias-srs.net', 'not found'),
			'alfaromeo' => array('whois.afilias-srs.net', 'not found'),
			'alibaba' => array('whois.afilias-srs.net', 'not found'),
			'alipay' => array('whois.afilias-srs.net', 'not found'),
			'allstate' => array('whois.afilias-srs.net', 'not found'),
			'ally' => array('whois.afilias-srs.net', 'not found'),
			'alsace' => array('whois.nic.alsace', 'not found'),
			'alstom' => array('whois.nic.alstom', 'no match'),
			'am' => array('whois.amnic.net', 'no match'),
			'americanfamily' => array('whois.nic.americanfamily', 'no match'),
			'amfam' => array('whois.nic.amfam', 'no match'),
			'amsterdam' => array('whois.nic.amsterdam', 'status: free'),
			'android' => array('whois.nic.google', 'domain not found.'),
			'anz' => array('whois.nic.anz', 'No Data Found'),
			'aol' => array('whois.nic.aol', 'no match'),
			'apartments' => array('whois.donuts.co', 'domain not found.'),
			'app' => array('whois.nic.google', 'not found'),
			'apple' => array('whois.afilias-srs.net', 'not found'),
			'aquarelle' => array('whois.nic.aquarelle', 'not found'),
			'ar' => array('whois.nic.ar', 'no se encuentra registrado'),
			'com.ar' => array('whois.nic.ar', 'no se encuentra registrado'),
			'archi' => array('whois.afilias.net', 'not found'),
			'army' => array('whois.nic.army', 'domain not found.'),
			'arpa' => array('whois.iana.org', 'but this server does not have'),
			'e164.arpa' => array('whois.ripe.net', 'no entries found'),
			'arte' => array('whois.nic.arte', 'no match'),
			'as' => array('whois.nic.as', 'not found'),
			'asda' => array('whois.nic.asda', 'no match'),
			'asia' => array('whois.nic.asia', 'not found'),
			'associates' => array('whois.donuts.co', 'domain not found.'),
			'at' => array('whois.nic.at', 'nothing found'),
			'ac.at' => array('whois.nic.at', 'nothing found'),
			'co.at' => array('whois.nic.at', 'nothing found'),
			'gv.at' => array('whois.nic.at', 'nothing found'),
			'or.at' => array('whois.nic.at', 'nothing found'),
			'priv.at' => array('whois.nic.priv.at', 'no entries found'),
			'attorney' => array('whois.nic.attorney', 'domain not found.'),
			'au' => array('whois.audns.net.au', 'not found'),
			'asn.au' => array('whois.audns.net.au', 'not found'),
			'com.au' => array('whois.audns.net.au', 'not found'),
			'csiro.au' => array('whois.audns.net.au', 'not found'),
			'edu.au' => array('whois.audns.net.au', 'not found'),
			'gov.au' => array('whois.audns.net.au', 'not found'),
			'id.au' => array('whois.audns.net.au', 'not found'),
			'net.au' => array('whois.audns.net.au', 'not found'),
			'org.au' => array('whois.audns.net.au', 'not found'),
			'conf.au' => array('whois.audns.net.au', 'not found'),
			'info.au' => array('whois.audns.net.au', 'not found'),
			'auction' => array('whois.donuts.co', 'domain not found.'),
			'audi' => array('whois.afilias-srs.net', 'not found'),
			'audio' => array('whois.uniregistry.net', 'is available for registration'),
			'auspost' => array('whois.nic.auspost', 'No Data Found'),
			'auto' => array('whois.uniregistry.net', 'is available for registration'),
			'autos' => array('whois.afilias-srs.net', 'not found'),
			'avianca' => array('whois.afilias-srs.net', 'not found'),
			'aw' => array('whois.nic.aw', 'is free'),
			'ax' => array('whois.ax', 'domain not found'),
			'baidu' => array('whois.gtld.knet.cn', 'the queried object does not exist'),
			'band' => array('whois.nic.band', 'domain not found.'),
			'bank' => array('whois.nic.bank', 'no match'),
			'barcelona' => array('whois.nic.barcelona', 'no match'),
			'barclaycard' => array('whois.nic.barclaycard', 'No Data Found'),
			'barclays' => array('whois.nic.barclays', 'No Data Found'),
			'barefoot' => array('whois.nic.barefoot', 'no match'),
			'bargains' => array('whois.donuts.co', 'domain not found.'),
			'bauhaus' => array('whois.nic.bauhaus', 'no match'),
			'bayern' => array('whois.nic.bayern', 'this domain name has not been registered.'),
			'bbc' => array('whois.nic.bbc', 'this domain name has not been registered'),
			'bbt' => array('whois.nic.bbt', 'no match'),
			'bbva' => array('whois.nic.bbva', 'no match'),
			'bcg' => array('whois.afilias-srs.net', 'not found'),
			'bcn' => array('whois.nic.bcn', 'no match'),
			'be' => array('whois.dns.be', 'status:\s+available'),
			'beats' => array('whois.afilias-srs.net', 'not found'),
			'beauty' => array('whois.nic.beauty', 'no match'),
			'beer' => array('whois.nic.beer', 'this domain name has not been registered'),
			'bentley' => array('whois.nic.bentley', 'this domain name has not been registered'),
			'berlin' => array('whois.nic.berlin', 'object does not exist'),
			'bestbuy' => array('whois.afilias-srs.net', 'not found'),
			'bet' => array('whois.afilias.net', 'not found'),
			'bg' => array('whois.register.bg', 'registration status: available'),
			'bi' => array('whois1.nic.bi', 'domain status: no object found'),
			'bible' => array('whois.nic.bible', 'No Data Found'),
			'bid' => array('whois.nic.bid', 'No Data Found'),
			'bike' => array('whois.donuts.co', 'domain not found'),
			'bingo' => array('whois.donuts.co', 'domain not found.'),
			'bio' => array('whois.afilias.net', 'not found'),
			'biz' => array('whois.biz', 'No Data Found'),
			'bj' => array('whois.nic.bj', 'no object found'),
			'black' => array('whois.afilias.net', 'not found'),
			'blackfriday' => array('whois.uniregistry.net', 'is available for registration'),
			'blockbuster' => array('whois.afilias-srs.net', 'not found'),
			'blue' => array('whois.afilias.net', 'not found'),
			'bm' => array('whois.bermudanic.bm', 'no match'),
			'com.bm' => array('whois.bermudanic.bm', 'no match'),
			'net.bm' => array('whois.bermudanic.bm', 'no match'),
			'org.bm' => array('whois.bermudanic.bm', 'no match'),
			'bms' => array('whois.nic.bms', 'no match'),
			'bn' => array('whois.bnnic.bn', 'not found'),
			'bnl' => array('whois.afilias-srs.net', 'not found'),
			'bnpparibas' => array('whois.afilias-srs.net', 'not found'),
			'boats' => array('whois.afilias-srs.net', 'not found'),
			'boehringer' => array('whois.afilias-srs.net', 'not found'),
			'bofa' => array('whois.nic.bofa', 'no match'),
			'bom' => array('whois.gtlds.nic.br', 'object does not exist'),
			'boo' => array('whois.nic.google', 'domain not found.'),
			'book' => array('whois.nic.book', 'this domain name has not been registered'),
			'bosch' => array('whois.nic.bosch', 'no match'),
			'bostik' => array('whois.nic.bostik', 'not found'),
			'boutique' => array('whois.donuts.co', 'domain not found.'),
			'boston' => array('whois.nic.boston', 'this domain name has not been registered'),
			'br' => array('whois.nic.br', 'No match for'),
			'app.br' => array('whois.nic.br', 'No match for'),
			'art.br' => array('whois.nic.br', 'No match for'),
			'com.br' => array('whois.nic.br', 'No match for'),
			'dev.br' => array('whois.nic.br', 'No match for'),
			'eco.br' => array('whois.nic.br', 'No match for'),
			'emp.br' => array('whois.nic.br', 'No match for'),
			'log.br' => array('whois.nic.br', 'No match for'),
			'net.br' => array('whois.nic.br', 'No match for'),
			'ong.br' => array('whois.nic.br', 'No match for'),
			'seg.br' => array('whois.nic.br', 'No match for'),
			'tec.br' => array('whois.nic.br', 'No match for'),
			'edu.br' => array('whois.nic.br', 'No match for'),
			'blog.br' => array('whois.nic.br', 'No match for'),
			'flog.br' => array('whois.nic.br', 'No match for'),
			'nom.br' => array('whois.nic.br', 'No match for'),
			'vlog.br' => array('whois.nic.br', 'No match for'),
			'wiki.br' => array('whois.nic.br', 'No match for'),
			'adm.br' => array('whois.nic.br', 'No match for'),
			'adv.br' => array('whois.nic.br', 'No match for'),
			'arq.br' => array('whois.nic.br', 'No match for'),
			'ato.br' => array('whois.nic.br', 'No match for'),
			'bib.br' => array('whois.nic.br', 'No match for'),
			'bio.br' => array('whois.nic.br', 'No match for'),
			'bmd.br' => array('whois.nic.br', 'No match for'),
			'cim.br' => array('whois.nic.br', 'No match for'),
			'cng.br' => array('whois.nic.br', 'No match for'),
			'cnt.br' => array('whois.nic.br', 'No match for'),
			'coz.br' => array('whois.nic.br', 'No match for'),
			'des.br' => array('whois.nic.br', 'No match for'),
			'det.br' => array('whois.nic.br', 'No match for'),
			'ecn.br' => array('whois.nic.br', 'No match for'),
			'enf.br' => array('whois.nic.br', 'No match for'),
			'eng.br' => array('whois.nic.br', 'No match for'),
			'eti.br' => array('whois.nic.br', 'No match for'),
			'fnd.br' => array('whois.nic.br', 'No match for'),
			'fot.br' => array('whois.nic.br', 'No match for'),
			'fst.br' => array('whois.nic.br', 'No match for'),
			'geo.br' => array('whois.nic.br', 'No match for'),
			'ggf.br' => array('whois.nic.br', 'No match for'),
			'jor.br' => array('whois.nic.br', 'No match for'),
			'lel.br' => array('whois.nic.br', 'No match for'),
			'mat.br' => array('whois.nic.br', 'No match for'),
			'med.br' => array('whois.nic.br', 'No match for'),
			'mus.br' => array('whois.nic.br', 'No match for'),
			'not.br' => array('whois.nic.br', 'No match for'),
			'ntr.br' => array('whois.nic.br', 'No match for'),
			'odo.br' => array('whois.nic.br', 'No match for'),
			'ppg.br' => array('whois.nic.br', 'No match for'),
			'pro.br' => array('whois.nic.br', 'No match for'),
			'psc.br' => array('whois.nic.br', 'No match for'),
			'qsl.br' => array('whois.nic.br', 'No match for'),
			'rep.br' => array('whois.nic.br', 'No match for'),
			'slg.br' => array('whois.nic.br', 'No match for'),
			'taxi.br' => array('whois.nic.br', 'No match for'),
			'teo.br' => array('whois.nic.br', 'No match for'),
			'trd.br' => array('whois.nic.br', 'No match for'),
			'vet.br' => array('whois.nic.br', 'No match for'),
			'zlg.br' => array('whois.nic.br', 'No match for'),
			'9guacu.br' => array('whois.nic.br', 'No match for'),
			'abc.br' => array('whois.nic.br', 'No match for'),
			'aju.br' => array('whois.nic.br', 'No match for'),
			'anani.br' => array('whois.nic.br', 'No match for'),
			'aparecida.br' => array('whois.nic.br', 'No match for'),
			'barueri.br' => array('whois.nic.br', 'No match for'),
			'belem.br' => array('whois.nic.br', 'No match for'),
			'bhz.br' => array('whois.nic.br', 'No match for'),
			'boavista.br' => array('whois.nic.br', 'No match for'),
			'bsb.br' => array('whois.nic.br', 'No match for'),
			'campinagrande.br' => array('whois.nic.br', 'No match for'),
			'campinas.br' => array('whois.nic.br', 'No match for'),
			'caxias.br' => array('whois.nic.br', 'No match for'),
			'contagem.br' => array('whois.nic.br', 'No match for'),
			'cuiaba.br' => array('whois.nic.br', 'No match for'),
			'curitiba.br' => array('whois.nic.br', 'No match for'),
			'feira.br' => array('whois.nic.br', 'No match for'),
			'floripa.br' => array('whois.nic.br', 'No match for'),
			'fortal.br' => array('whois.nic.br', 'No match for'),
			'foz.br' => array('whois.nic.br', 'No match for'),
			'goiania.br' => array('whois.nic.br', 'No match for'),
			'gru.br' => array('whois.nic.br', 'No match for'),
			'jab.br' => array('whois.nic.br', 'No match for'),
			'jampa.br' => array('whois.nic.br', 'No match for'),
			'jdf.br' => array('whois.nic.br', 'No match for'),
			'joinville.br' => array('whois.nic.br', 'No match for'),
			'londrina.br' => array('whois.nic.br', 'No match for'),
			'macapa.br' => array('whois.nic.br', 'No match for'),
			'maceio.br' => array('whois.nic.br', 'No match for'),
			'manaus.br' => array('whois.nic.br', 'No match for'),
			'maringa.br' => array('whois.nic.br', 'No match for'),
			'morena.br' => array('whois.nic.br', 'No match for'),
			'natal.br' => array('whois.nic.br', 'No match for'),
			'niteroi.br' => array('whois.nic.br', 'No match for'),
			'osasco.br' => array('whois.nic.br', 'No match for'),
			'palmas.br' => array('whois.nic.br', 'No match for'),
			'poa.br' => array('whois.nic.br', 'No match for'),
			'pvh.br' => array('whois.nic.br', 'No match for'),
			'recife.br' => array('whois.nic.br', 'No match for'),
			'ribeirao.br' => array('whois.nic.br', 'No match for'),
			'rio.br' => array('whois.nic.br', 'No match for'),
			'riobranco.br' => array('whois.nic.br', 'No match for'),
			'riopreto.br' => array('whois.nic.br', 'No match for'),
			'salvador.br' => array('whois.nic.br', 'No match for'),
			'sampa.br' => array('whois.nic.br', 'No match for'),
			'santamaria.br' => array('whois.nic.br', 'No match for'),
			'santoandre.br' => array('whois.nic.br', 'No match for'),
			'saobernardo.br' => array('whois.nic.br', 'No match for'),
			'saogonca.br' => array('whois.nic.br', 'No match for'),
			'sjc.br' => array('whois.nic.br', 'No match for'),
			'slz.br' => array('whois.nic.br', 'No match for'),
			'sorocaba.br' => array('whois.nic.br', 'No match for'),
			'the.br' => array('whois.nic.br', 'No match for'),
			'udi.br' => array('whois.nic.br', 'No match for'),
			'vix.br' => array('whois.nic.br', 'No match for'),
			'agr.br' => array('whois.nic.br', 'No match for'),
			'esp.br' => array('whois.nic.br', 'No match for'),
			'etc.br' => array('whois.nic.br', 'No match for'),
			'far.br' => array('whois.nic.br', 'No match for'),
			'imb.br' => array('whois.nic.br', 'No match for'),
			'ind.br' => array('whois.nic.br', 'No match for'),
			'inf.br' => array('whois.nic.br', 'No match for'),
			'radio.br' => array('whois.nic.br', 'No match for'),
			'rec.br' => array('whois.nic.br', 'No match for'),
			'srv.br' => array('whois.nic.br', 'No match for'),
			'tmp.br' => array('whois.nic.br', 'No match for'),
			'tur.br' => array('whois.nic.br', 'No match for'),
			'tv.br' => array('whois.nic.br', 'No match for'),
			'am.br' => array('whois.nic.br', 'No match for'),
			'coop.br' => array('whois.nic.br', 'No match for'),
			'fm.br' => array('whois.nic.br', 'No match for'),
			'g12.br' => array('whois.nic.br', 'No match for'),
			'gov.br' => array('whois.nic.br', 'No match for'),
			'mil.br' => array('whois.nic.br', 'No match for'),
			'org.br' => array('whois.nic.br', 'No match for'),
			'psi.br' => array('whois.nic.br', 'No match for'),
			'b.br' => array('whois.nic.br', 'No match for'),
			'def.br' => array('whois.nic.br', 'No match for'),
			'jus.br' => array('whois.nic.br', 'No match for'),
			'leg.br' => array('whois.nic.br', 'No match for'),
			'mp.br' => array('whois.nic.br', 'No match for'),
			'tc.br' => array('whois.nic.br', 'No match for'),
			'bradesco' => array('whois.nic.bradesco', 'this domain name has not been registered'),
			'bridgestone' => array('whois.nic.bridgestone', 'not found'),
			'broadway' => array('whois.nic.broadway', 'this domain name has not been registered'),
			'broker' => array('whois.nic.broker', 'no match'),
			'brother' => array('whois.nic.brother', 'not found'),
			'brussels' => array('whois.nic.brussels', 'domain not found.'),
			'budapest' => array('whois.nic.budapest', 'this domain name has not been registered.'),
			'bugatti' => array('whois.afilias-srs.net', 'not found'),
			'build' => array('whois.nic.build', 'No Data Found'),
			'builders' => array('whois.donuts.co', 'domain not found'),
			'business' => array('whois.donuts.co', 'domain not found.'),
			'buy' => array('whois.afilias-srs.net', 'not found'),
			'buzz' => array('whois.nic.buzz', 'No Data Found'),
			'bw' => array('whois.nic.net.bw', 'no object found'),
			'by' => array('whois.cctld.by', 'object does not exist'),
			'bz' => array('whois.afilias-grs.info', 'not found'),
			'za.bz' => array('whois.afilias-grs.info', 'not found'),
			'bzh' => array('whois.nic.bzh', 'not found'),
			'ca' => array('whois.cira.ca', 'not found'),
			'co.ca' => array('whois.co.ca', 'is available.'),
			'cab' => array('whois.donuts.co', 'domain not found'),
			'cafe' => array('whois.donuts.co', 'not found'),
			'cal' => array('whois.nic.google', 'domain not found.'),
			'camera' => array('whois.donuts.co', 'domain not found'),
			'camp' => array('whois.donuts.co', 'domain not found'),
			'cancerresearch' => array('whois.nic.cancerresearch', 'No Data Found'),
			'canon' => array('whois.nic.canon', 'not found'),
			'capetown' => array('whois.nic.capetown', 'available'),
			'capital' => array('whois.donuts.co', 'domain not found.'),
			'capitalone' => array('whois.nic.capitalone', 'no match'),
			'car' => array('whois.uniregistry.net', 'is available for registration'),
			'cards' => array('whois.donuts.co', 'domain not found.'),
			'care' => array('whois.donuts.co', 'domain not found.'),
			'career' => array('whois.nic.career', 'no match'),
			'careers' => array('whois.donuts.co', 'domain not found'),
			'cars' => array('whois.uniregistry.net', 'is available for registration'),
			'casa' => array('whois.nic.casa', 'this domain name has not been registered'),
			'case' => array('whois.afilias-srs.net', 'not found'),
			'caseih' => array('whois.afilias-srs.net', 'not found'),
			'cash' => array('whois.donuts.co', 'domain not found.'),
			'casino' => array('whois.donuts.co', 'domain not found.'),
			'cat' => array('whois.nic.cat', 'no matching objects found'),
			'catering' => array('whois.donuts.co', 'domain not found.'),
			'cba' => array('whois.nic.cba', 'No Data Found'),
			'cbs' => array('whois.afilias-srs.net', 'not found'),
			'cc' => array('ccwhois.verisign-grs.com', 'no match'),
			'cd' => array('whois.nic.cd', 'no object found'),
			'ceb' => array('whois.afilias-srs.net', 'not found'),
			'center' => array('whois.donuts.co', 'domain not found'),
			'cern' => array('whois.afilias-srs.net', 'not found'),
			'cf' => array('whois.freenom.com', 'domain name not known'),
			'cfa' => array('whois.nic.cfa', 'no match'),
			'cfd' => array('whois.nic.cfd', 'no match'),
			'ch' => array('whois.nic.ch', 'rdap' => 'rdap.nic.ch', 'domain name can be registered'),
			'chanel' => array('whois.nic.chanel', 'no match'),
			'channel' => array('whois.nic.google', 'domain not found.'),
			'charity' => array('whois.nic.charity', 'domain not found.'),
			'chat' => array('whois.donuts.co', 'domain not found.'),
			'cheap' => array('whois.donuts.co', 'domain not found.'),
			'chintai' => array('whois.nic.chintai', 'No Data Found'),
			'christmas' => array('whois.uniregistry.net', 'is available for registration'),
			'chrome' => array('whois.nic.google', 'domain not found.'),
			'chrysler' => array('whois.afilias-srs.net', 'not found'),
			'church' => array('whois.donuts.co', 'domain not found.'),
			'ci' => array('whois.nic.ci', 'no object found'),
			'cipriani' => array('whois.afilias-srs.net', 'not found'),
			'city' => array('whois.donuts.co', 'domain not found.'),
			'cityeats' => array('whois.nic.cityeats', 'no match'),
			'cl' => array('whois.nic.cl', 'no entries found'),
			'claims' => array('whois.donuts.co', 'domain not found.'),
			'cleaning' => array('whois.donuts.co', 'domain not found.'),
			'click' => array('whois.uniregistry.net', 'is available for registration'),
			'clinic' => array('whois.donuts.co', 'domain not found.'),
			'clinique' => array('whois.afilias-srs.net', 'not found'),
			'clothing' => array('whois.donuts.co', 'domain not found'),
			'cloud' => array('whois.nic.cloud', 'No Data Found'),
			'club' => array('whois.nic.club', 'No Data Found'),
			'clubmed' => array('whois.nic.clubmed', 'no match'),
			'cm' => array('whois.netcom.cm', 'status: not registered'),
			'cn' => array('whois.cnnic.cn', 'no match'),
			'ac.cn' => array('whois.cnnic.cn', 'no matching record'),
			'ah.cn' => array('whois.cnnic.cn', 'no matching record'),
			'bj.cn' => array('whois.cnnic.cn', 'no matching record'),
			'com.cn' => array('whois.cnnic.cn', 'no matching record'),
			'cq.cn' => array('whois.cnnic.cn', 'no matching record'),
			'gd.cn' => array('whois.cnnic.cn', 'no matching record'),
			'gov.cn' => array('whois.cnnic.cn', 'no matching record'),
			'gs.cn' => array('whois.cnnic.cn', 'no matching record'),
			'gx.cn' => array('whois.cnnic.cn', 'no matching record'),
			'gz.cn' => array('whois.cnnic.cn', 'no matching record'),
			'hb.cn' => array('whois.cnnic.cn', 'no matching record'),
			'he.cn' => array('whois.cnnic.cn', 'no matching record'),
			'hi.cn' => array('whois.cnnic.cn', 'no matching record'),
			'hk.cn' => array('whois.cnnic.cn', 'no matching record'),
			'hl.cn' => array('whois.cnnic.cn', 'no matching record'),
			'hn.cn' => array('whois.cnnic.cn', 'no matching record'),
			'jl.cn' => array('whois.cnnic.cn', 'no matching record'),
			'js.cn' => array('whois.cnnic.cn', 'no matching record'),
			'ln.cn' => array('whois.cnnic.cn', 'no matching record'),
			'mo.cn' => array('whois.cnnic.cn', 'no matching record'),
			'net.cn' => array('whois.cnnic.cn', 'no matching record'),
			'nm.cn' => array('whois.cnnic.cn', 'no matching record'),
			'nx.cn' => array('whois.cnnic.cn', 'no matching record'),
			'org.cn' => array('whois.cnnic.cn', 'no matching record'),
			'qh.cn' => array('whois.cnnic.cn', 'no matching record'),
			'sc.cn' => array('whois.cnnic.cn', 'no matching record'),
			'sh.cn' => array('whois.cnnic.cn', 'no matching record'),
			'sn.cn' => array('whois.cnnic.cn', 'no matching record'),
			'tj.cn' => array('whois.cnnic.cn', 'no matching record'),
			'tw.cn' => array('whois.cnnic.cn', 'no matching record'),
			'xj.cn' => array('whois.cnnic.cn', 'no matching record'),
			'xz.cn' => array('whois.cnnic.cn', 'no matching record'),
			'yn.cn' => array('whois.cnnic.cn', 'no matching record'),
			'zj.cn' => array('whois.cnnic.cn', 'no matching record'),
			'co' => array('whois.nic.co', 'No Data Found'),
			'com.co' => array('whois.nic.co', 'No Data Found'),
			'net.co' => array('whois.nic.co', 'No Data Found'),
			'nom.co' => array('whois.nic.co', 'No Data Found'),
			'coach' => array('whois.donuts.co', 'domain not found.'),
			'codes' => array('whois.donuts.co', 'domain not found.'),
			'coffee' => array('whois.donuts.co', 'domain not found'),
			'cologne' => array('whois.nic.koeln', 'no information was found'),
			'com' => array('whois.crsnic.net', 'No match for'),
			'ae.com' => array('whois.verisign-grs.com', 'no match'),
			'africa.com' => array('srs-whois.dns.net.za', 'no information was found'),
			'ar.com' => array('whois.verisign-grs.com', 'no match'),
			'br.com' => array('whois.verisign-grs.com', 'no match'),
			'cn.com' => array('whois.verisign-grs.com', 'no match'),
			'co.com' => array('whois.verisign-grs.com', 'no match'),
			'de.com' => array('whois.verisign-grs.com', 'no match'),
			'eu.com' => array('whois.verisign-grs.com', 'no match'),
			'gb.com' => array('whois.verisign-grs.com', 'no match'),
			'gr.com' => array('whois.verisign-grs.com', 'no match'),
			'hu.com' => array('whois.verisign-grs.com', 'no match'),
			'jpn.com' => array('whois.verisign-grs.com', 'no match'),
			'kr.com' => array('whois.verisign-grs.com', 'no match'),
			'lovesnaija.com' => array('srs-whois.dns.net.za', 'no information was found'),
			'no.com' => array('whois.verisign-grs.com', 'no match'),
			'qc.com' => array('whois.verisign-grs.com', 'no match'),
			'ru.com' => array('whois.verisign-grs.com', 'no match'),
			'sa.com' => array('whois.verisign-grs.com', 'no match'),
			'se.com' => array('whois.verisign-grs.com', 'no match'),
			'uk.com' => array('whois.verisign-grs.com', 'no match'),
			'us.com' => array('whois.verisign-grs.com', 'no match'),
			'uy.com' => array('whois.verisign-grs.com', 'no match'),
			'web.com' => array('whois.verisign-grs.com', 'no match'),
			'za.com' => array('whois.verisign-grs.com', 'no match'),
			'comcast' => array('whois.nic.comcast', 'this domain name has not been registered.'),
			'commbank' => array('whois.nic.commbank', 'No Data Found'),
			'community' => array('whois.donuts.co', 'domain not found.'),
			'company' => array('whois.donuts.co', 'domain not found'),
			'compare' => array('whois.nic.compare', 'No Data Found'),
			'computer' => array('whois.donuts.co', 'domain not found'),
			'comsec' => array('whois.nic.comsec', 'no match'),
			'condos' => array('whois.donuts.co', 'domain not found.'),
			'construction' => array('whois.donuts.co', 'domain not found'),
			'consulting' => array('whois.donuts.co', 'domain not found.'),
			'contact' => array('whois.nic.contact', 'domain not found.'),
			'contractors' => array('whois.donuts.co', 'domain not found'),
			'cooking' => array('whois.nic.cooking', 'this domain name has not been registered'),
			'cookingchannel' => array('whois.nic.cookingchannel', 'no match'),
			'cool' => array('whois.donuts.co', 'domain not found.'),
			'corsica' => array('whois.nic.corsica', 'not found'),
			'country' => array('whois.uniregistry.net', 'is available for registration'),
			'coupon' => array('whois.nic.coupon', 'No Data Found'),
			'coupons' => array('whois.donuts.co', 'not found'),
			'courses' => array('whois.nic.courses', 'No Data Found'),
			'cpa' => array('whois.nic.cpa', 'No Data Found'),
			'cr' => array('whois.nic.cr', 'no entries found'),
			'credit' => array('whois.donuts.co', 'domain not found.'),
			'creditcard' => array('whois.donuts.co', 'domain not found.'),
			'creditunion' => array('whois.afilias-srs.net', 'not found'),
			'cricket' => array('whois.nic.cricket', 'No Data Found'),
			'cruises' => array('whois.donuts.co', 'domain not found.'),
			'cuisinella' => array('whois.nic.cuisinella', 'No Data Found'),
			'cx' => array('whois.nic.cx', 'no object found'),
			'cymru' => array('whois.nic.cymru', 'this domain name has not been registered'),
			'cz' => array('whois.nic.cz', 'no entries found'),
			'dabur' => array('whois.afilias-srs.net', 'not found'),
			'dad' => array('whois.nic.google', 'domain not found.'),
			'dance' => array('whois.nic.dance', 'domain not found.'),
			'data' => array('whois.nic.data', 'not found'),
			'date' => array('whois.nic.date', 'No Data Found'),
			'dating' => array('whois.donuts.co', 'domain not found.'),
			'datsun' => array('whois.nic.gmo', 'not found'),
			'day' => array('whois.nic.google', 'domain not found.'),
			'dclk' => array('whois.nic.google', 'domain not found.'),
			'dds' => array('whois.nic.dds', 'this domain name has not been registered'),
			'de' => array('whois.denic.de', 'status: free'),
			'deal' => array('whois.nic.deal', 'this domain name has not been registered'),
			'dealer' => array('whois.nic.dealer', 'is available for registration'),
			'deals' => array('whois.donuts.co', 'domain not found.'),
			'degree' => array('whois.nic.degree', 'domain not found.'),
			'delivery' => array('whois.donuts.co', 'domain not found.'),
			'delta' => array('whois.afilias-srs.net', 'not found'),
			'democrat' => array('whois.nic.democrat', 'domain not found.'),
			'dental' => array('whois.donuts.co', 'domain not found.'),
			'dentist' => array('whois.nic.dentist', 'domain not found.'),
			'dev' => array('whois.nic.google', 'domain not found.'),
			'diamonds' => array('whois.donuts.co', 'domain not found'),
			'diet' => array('whois.uniregistry.net', 'is available for registration'),
			'digital' => array('whois.donuts.co', 'domain not found.'),
			'direct' => array('whois.donuts.co', 'domain not found.'),
			'directory' => array('whois.donuts.co', 'domain not found'),
			'discount' => array('whois.donuts.co', 'domain not found.'),
			'dish' => array('whois.afilias-srs.net', 'not found'),
			'diy' => array('whois.nic.diy', 'no match'),
			'dk' => array('whois.dk-hostmaster.dk', 'no entries found'),
			'dm' => array('whois.nic.dm', 'not found'),
			'do' => array('whois.nic.do', 'no object found'),
			'docs' => array('whois.nic.google', 'domain not found.'),
			'doctor' => array('whois.donuts.co', 'not found'),
			'dodge' => array('whois.afilias-srs.net', 'not found'),
			'dog' => array('whois.donuts.co', 'not found'),
			'domains' => array('whois.donuts.co', 'domain not found'),
			'dot' => array('whois.afilias-srs.net', 'not found'),
			'download' => array('whois.nic.download', 'No Data Found'),
			'drive' => array('whois.nic.google', 'not found'),
			'dtv' => array('whois.afilias-srs.net', 'not found'),
			'dubai' => array('whois.nic.dubai', 'no match'),
			'dunlop' => array('whois.afilias-srs.net', 'not found'),
			'durban' => array('whois.nic.durban', 'available'),
			'dvr' => array('whois.afilias-srs.net', 'not found'),
			'dz' => array('whois.nic.dz', 'no object found!'),
			'earth' => array('whois.nic.earth', 'No Data Found'),
			'eat' => array('whois.nic.google', 'domain not found.'),
			'eco' => array('whois.afilias-srs.net', 'not found'),
			'edeka' => array('whois.afilias-srs.net', 'not found'),
			'edu' => array('whois.educause.edu', 'no match'),
			'education' => array('whois.donuts.co', 'domain not found'),
			'ee' => array('whois.eenet.ee', 'not found'),
			'email' => array('whois.donuts.co', 'domain not found'),
			'emerck' => array('whois.afilias-srs.net', 'not found'),
			'energy' => array('whois.donuts.co', 'domain not found.'),
			'engineer' => array('whois.nic.engineer', 'domain not found.'),
			'engineering' => array('whois.donuts.co', 'domain not found.'),
			'enterprises' => array('whois.donuts.co', 'domain not found'),
			'equipment' => array('whois.donuts.co', 'domain not found'),
			'ericsson' => array('whois.nic.ericsson', 'no match'),
			'erni' => array('whois.nic.erni', 'no match'),
			'esq' => array('whois.nic.google', 'domain not found.'),
			'estate' => array('whois.donuts.co', 'domain not found'),
			'esurance' => array('whois.afilias-srs.net', 'not found'),
			'et' => array('whois.ethiotelecom.et', 'the queried object does not exist'),
			'eu' => array('whois.eu', 'Status: AVAILABLE'),
			'eurovision' => array('whois.nic.eurovision', 'no match'),
			'eus' => array('whois.nic.eus', 'no matching objects found'),
			'events' => array('whois.donuts.co', 'domain not found.'),
			'exchange' => array('whois.donuts.co', 'domain not found.'),
			'expert' => array('whois.donuts.co', 'domain not found'),
			'exposed' => array('whois.donuts.co', 'domain not found'),
			'express' => array('whois.donuts.co', 'not found'),
			'extraspace' => array('whois.afilias-srs.net', 'not found'),
			'fage' => array('whois.afilias-srs.net', 'not found'),
			'fail' => array('whois.donuts.co', 'domain not found.'),
			'fairwinds' => array('whois.nic.fairwinds', 'no match'),
			'faith' => array('whois.nic.faith', 'No Data Found'),
			'family' => array('whois.nic.family', 'domain not found.'),
			'fan' => array('whois.nic.fan', 'not found'),
			'farm' => array('whois.donuts.co', 'domain not found'),
			'fashion' => array('whois.nic.fashion', 'this domain name has not been registered'),
			'fedex' => array('whois.afilias-srs.net', 'not found'),
			'ferrari' => array('whois.afilias-srs.net', 'not found'),
			'fi' => array('whois.fi', 'not found'),
			'fiat' => array('whois.afilias-srs.net', 'not found'),
			'fidelity' => array('whois.nic.fidelity', 'no match'),
			'fido' => array('whois.afilias-srs.net', 'not found'),
			'film' => array('whois.nic.film', 'no match'),
			'final' => array('whois.gtlds.nic.br', 'object does not exist'),
			'finance' => array('whois.donuts.co', 'domain not found.'),
			'financial' => array('whois.donuts.co', 'domain not found.'),
			'firestone' => array('whois.nic.firestone', 'not found'),
			'firmdale' => array('whois.nic.firmdale', 'not found'),
			'fish' => array('whois.donuts.co', 'domain not found.'),
			'fishing' => array('whois.nic.fishing', 'this domain name has not been registered'),
			'fit' => array('whois.nic.fit', 'this domain name has not been registered'),
			'fitness' => array('whois.donuts.co', 'domain not found.'),
			'fj' => array('whois.usp.ac.fj', 'not found'),
			'flights' => array('whois.donuts.co', 'domain not found'),
			'florist' => array('whois.donuts.co', 'domain not found'),
			'flowers' => array('whois.uniregistry.net', 'is available for registration'),
			'fly' => array('whois.nic.google', 'domain not found.'),
			'foo' => array('whois.nic.google', 'domain not found.'),
			'foodnetwork' => array('whois.nic.foodnetwork', 'no match'),
			'football' => array('whois.donuts.co', 'domain not found.'),
			'forex' => array('whois.nic.forex', 'no match'),
			'forsale' => array('whois.nic.forsale', 'domain not found.'),
			'foundation' => array('whois.donuts.co', 'domain not found.'),
			'fr' => array('whois.nic.fr', 'no entries found'),
			'free' => array('whois.nic.free', 'this domain name has not been registered'),
			'aeroport.fr' => array('whois.smallregistry.net', 'object not found'),
			'asso.fr' => array('whois.nic.fr', 'no entries found'),
			'avocat.fr' => array('whois.smallregistry.net', 'object not found'),
			'chambagri.fr' => array('whois.smallregistry.net', 'object not found'),
			'chirurgiens-dentistes.fr' => array('whois.smallregistry.net', 'object not found'),
			'com.fr' => array('whois.nic.fr', 'no entries found'),
			'experts-comptables.fr' => array('whois.smallregistry.net', 'object not found'),
			'geometre-expert.fr' => array('whois.smallregistry.net', 'object not found'),
			'medecin.fr' => array('whois.smallregistry.net', 'object not found'),
			'notaires.fr' => array('whois.smallregistry.net', 'object not found'),
			'pharmacien.fr' => array('whois.smallregistry.net', 'object not found'),
			'port.fr' => array('whois.smallregistry.net', 'object not found'),
			'presse.fr' => array('whois.nic.fr', 'no entries found'),
			'tm.fr' => array('whois.nic.fr', 'no entries found'),
			'veterinaire.fr' => array('whois.smallregistry.net', 'object not found'),
			'frogans' => array('whois.nic.frogans', 'not found'),
			'frontdoor' => array('whois.nic.frontdoor', 'no match'),
			'fujitsu' => array('whois.nic.gmo', 'not found'),
			'fund' => array('whois.donuts.co', 'domain not found.'),
			'furniture' => array('whois.donuts.co', 'domain not found.'),
			'futbol' => array('whois.nic.futbol', 'domain not found.'),
			'fyi' => array('whois.donuts.co', 'not found'),
			'ga' => array('whois.freenom.com', 'domain name not known'),
			'gal' => array('whois.nic.gal', 'no matching objects found'),
			'gallery' => array('whois.donuts.co', 'domain not found'),
			'gallo' => array('whois.nic.gallo', 'no match'),
			'gallup' => array('whois.afilias-srs.net', 'not found'),
			'game' => array('whois.uniregistry.net', 'is available for registration'),
			'games' => array('whois.nic.games', 'domain not found.'),
			'garden' => array('whois.nic.garden', 'this domain name has not been registered'),
			'gbiz' => array('whois.nic.google', 'domain not found.'),
			'gdn' => array('whois.nic.gdn', 'not found'),
			'ge' => array('whois.nic.ge', 'no match'),
			'com.ge' => array('whois.nic.ge', 'no match'),
			'edu.ge' => array('whois.nic.ge', 'no match'),
			'net.ge' => array('whois.nic.ge', 'no match'),
			'org.ge' => array('whois.nic.ge', 'no match'),
			'pvt.ge' => array('whois.nic.ge', 'no match'),
			'gea' => array('whois.afilias-srs.net', 'not found'),
			'genting' => array('whois.nic.genting', 'no match'),
			'george' => array('whois.nic.george', 'no match'),
			'gf' => array('whois.mediaserv.net', 'no object found'),
			'gg' => array('whois.channelisles.net', 'not found'),
			'ggee' => array('whois.nic.ggee', 'not found'),
			'gi' => array('whois.afilias-grs.info', 'not found'),
			'gift' => array('whois.uniregistry.net', 'is available for registration'),
			'gifts' => array('whois.donuts.co', 'domain not found.'),
			'gives' => array('whois.nic.gives', 'domain not found.'),
			'giving' => array('whois.nic.giving', 'No Data Found'),
			'gl' => array('whois.nic.gl', 'no object found'),
			'glass' => array('whois.donuts.co', 'domain not found'),
			'gle' => array('whois.nic.google', 'domain not found.'),
			'global' => array('whois.afilias-srs.net', 'not found'),
			'globo' => array('whois.gtlds.nic.br', 'object does not exist'),
			'gmail' => array('whois.nic.google', 'domain not found.'),
			'gmbh' => array('whois.donuts.co', 'not found'),
			'gmx' => array('whois-fe1.gmx.tango.knipp.de', 'no match'),
			'godaddy' => array('whois.afilias-srs.net', 'not found'),
			'gold' => array('whois.donuts.co', 'not found'),
			'goldpoint' => array('whois.nic.goldpoint', 'not found'),
			'golf' => array('whois.donuts.co', 'not found'),
			'goo' => array('whois.nic.gmo', 'not found'),
			'goodyear' => array('whois.afilias-srs.net', 'not found'),
			'goog' => array('whois.nic.google', 'domain not found.'),
			'google' => array('whois.nic.google', 'domain not found.'),
			'gop' => array('whois.nic.gop', 'this domain name has not been registered'),
			'gov' => array('whois.dotgov.gov', 'no match'),
			'gp' => array('whois.nic.gp', 'no record found'),
			'com.gp' => array('whois.nic.gp', 'no record found'),
			'mobi.gp' => array('whois.nic.gp', 'no record found'),
			'net.gp' => array('whois.nic.gp', 'no record found'),
			'gq' => array('whois.freenom.com', 'domain name not known'),
			'graphics' => array('whois.donuts.co', 'domain not found'),
			'gratis' => array('whois.donuts.co', 'domain not found.'),
			'green' => array('whois.afilias.net', 'not found'),
			'gripe' => array('whois.donuts.co', 'domain not found.'),
			'group' => array('whois.donuts.co', 'not found'),
			'gs' => array('whois.nic.gs', 'no object found'),
			'guge' => array('whois.nic.google', 'not found'),
			'guide' => array('whois.donuts.co', 'domain not found.'),
			'guitars' => array('whois.uniregistry.net', 'is available for registration'),
			'guru' => array('whois.donuts.co', 'domain not found'),
			'gy' => array('whois.registry.gy', 'domain status: no object found'),
			'hamburg' => array('whois.nic.hamburg', 'object does not exist'),
			'hangout' => array('whois.nic.google', 'domain not found.'),
			'haus' => array('whois.nic.haus', 'domain not found.'),
			'hdfc' => array('whois.afilias-srs.net', 'not found'),
			'hdfcbank' => array('whois.afilias-srs.net', 'not found'),
			'health' => array('whois.nic.health', 'No Data Found'),
			'healthcare' => array('whois.donuts.co', 'domain not found.'),
			'help' => array('whois.uniregistry.net', 'is available for registration'),
			'helsinki' => array('whois.afilias-srs.net', 'not found'),
			'here' => array('whois.nic.google', 'domain not found.'),
			'hermes' => array('whois.afilias-srs.net', 'not found'),
			'hgtv' => array('whois.nic.hgtv', 'no match'),
			'hiphop' => array('whois.uniregistry.net', 'is available for registration'),
			'hisamitsu' => array('whois.nic.gmo', 'not found'),
			'hitachi' => array('whois.nic.gmo', 'not found'),
			'hiv' => array('whois.afilias-srs.net', 'not found'),
			'hk' => array('whois.hkirc.hk', 'the domain has not been registered'),
			'com.hk' => array('whois.hkdnr.net.hk', 'the domain has not been registered'),
			'edu.hk' => array('whois.hkdnr.net.hk', 'the domain has not been registered'),
			'net.hk' => array('whois.hkdnr.net.hk', 'the domain has not been registered'),
			'org.hk' => array('whois.hkdnr.net.hk', 'the domain has not been registered'),
			'hkt' => array('whois.afilias-srs.net', 'not found'),
			'hn' => array('whois.nic.hn', 'no object found'),
			'hockey' => array('whois.donuts.co', 'not found'),
			'holdings' => array('whois.donuts.co', 'domain not found'),
			'holiday' => array('whois.donuts.co', 'domain not found'),
			'homedepot' => array('whois.afilias-srs.net', 'not found'),
			'homes' => array('whois.afilias-srs.net', 'not found'),
			'honda' => array('whois.nic.honda', 'not found'),
			'hospital' => array('whois.nic.hospital', 'domain not found.'),
			'horse' => array('whois.nic.horse', 'this domain name has not been registered'),
			'hosting' => array('whois.nic.hosting', 'is available for registration'),
			'hot' => array('whois.nic.hot', 'this domain name has not been registered'),
			'hotels' => array('whois.nic.hotels', 'No Data Found'),
			'house' => array('whois.donuts.co', 'domain not found'),
			'how' => array('whois.nic.google', 'domain not found.'),
			'hr' => array('whois.dns.hr', 'no entries found'),
			'ht' => array('whois.nic.ht', 'no object found'),
			'hu' => array('whois.nic.hu', 'no match'),
			'hughes' => array('whois.afilias-srs.net', 'not found'),
			'hyundai' => array('whois.nic.hyundai', 'not found'),
			'ibm' => array('whois.nic.ibm', 'No Data Found'),
			'icbc' => array('whois.afilias-srs.net', 'not found'),
			'ice' => array('whois.nic.ice', 'no match'),
			'id' => array('whois.id', 'domain not found'),
			'ac.id' => array('whois.id', 'domain not found'),
			'biz.id' => array('whois.id', 'domain not found'),
			'co.id' => array('whois.id', 'domain not found'),
			'desa.id' => array('whois.id', 'domain not found'),
			'go.id' => array('whois.id', 'domain not found'),
			'mil.id' => array('whois.id', 'domain not found'),
			'my.id' => array('whois.id', 'domain not found'),
			'net.id' => array('whois.id', 'domain not found'),
			'or.id' => array('whois.id', 'domain not found'),
			'ponpes.id' => array('whois.id', 'domain not found'),
			'sch.id' => array('whois.id', 'domain not found'),
			'web.id' => array('whois.id', 'domain not found'),
			'ie' => array('whois.weare.ie', 'not found'),
			'ifm' => array('whois.nic.ifm', 'no match'),
			'ikano' => array('whois.ikano.tld-box.at', 'object does not exist'),
			'co.il' => array('whois.isoc.org.il', 'no data was found'),
			'org.il' => array('whois.isoc.org.il', 'no data was found'),
			'im' => array('whois.nic.im', 'not found'),
			'imamat' => array('whois.afilias-srs.net', 'not found'),
			'immo' => array('whois.donuts.co', 'domain not found.'),
			'immobilien' => array('whois.nic.immobilien', 'domain not found.'),
			'in' => array('whois.registry.in', 'No Data Found'),
			'co.in' => array('whois.registry.in', 'No Data Found'),
			'firm.in' => array('whois.registry.in', 'No Data Found'),
			'gen.in' => array('whois.registry.in', 'No Data Found'),
			'ind.in' => array('whois.registry.in', 'No Data Found'),
			'net.in' => array('whois.registry.in', 'No Data Found'),
			'org.in' => array('whois.registry.in', 'No Data Found'),
			'inc' => array('whois.nic.inc', 'available for registration'),
			'industries' => array('whois.donuts.co', 'domain not found.'),
			'infiniti' => array('whois.nic.gmo', 'not found'),
			'info' => array('whois.afilias.info', 'not found'),
			'ing' => array('whois.nic.google', 'domain not found.'),
			'institute' => array('whois.donuts.co', 'domain not found'),
			'insurance' => array('whois.nic.insurance', 'no match'),
			'insure' => array('whois.donuts.co', 'domain not found.'),
			'int' => array('whois.iana.org', 'but this server does not have'),
			'international' => array('whois.donuts.co', 'domain not found'),
			'investments' => array('whois.donuts.co', 'domain not found.'),
			'io' => array('whois.nic.io', 'not found'),
			'ir' => array('whois.nic.ir', 'no entries found'),
			'irish' => array('whois.nic.irish', 'domain not found.'),
			'is' => array('whois.isnic.is', 'no entries found'),
			'ismaili' => array('whois.afilias-srs.net', 'not found'),
			'ist' => array('whois.afilias-srs.net', 'not found'),
			'istanbul' => array('whois.afilias-srs.net', 'not found'),
			'it' => array('whois.nic.it', 'status: available'),
			'itv' => array('whois.afilias-srs.net', 'not found'),
			'iveco' => array('whois.afilias-srs.net', 'not found'),
			'jaguar' => array('whois.nic.jaguar', 'no match'),
			'java' => array('whois.nic.java', 'no match'),
			'jcb' => array('whois.nic.gmo', 'not found'),
			'jcp' => array('whois.afilias-srs.net', 'not found'),
			'je' => array('whois.channelisles.net', 'not found'),
			'jeep' => array('whois.afilias-srs.net', 'not found'),
			'jetzt' => array('whois.nic.jetzt', 'not found'),
			'jewelry' => array('whois.donuts.co', 'not found'),
			'jll' => array('whois.afilias-srs.net', 'not found'),
			'jobs' => array('whois.nic.jobs', 'no match'),
			'joburg' => array('whois.nic.joburg', 'available'),
			'joy' => array('whois.nic.joy', 'this domain name has not been registered'),
			'jp' => array('whois.jprs.jp', 'no match'),
			'ac.jp' => array('whois.jprs.jp', 'no match'),
			'juegos' => array('whois.uniregistry.net', 'is available for registration'),
			'juniper' => array('whois.nic.juniper', 'no match'),
			'kaufen' => array('whois.nic.kaufen', 'domain not found.'),
			'kddi' => array('whois.nic.kddi', 'not found'),
			'ke' => array('whois.kenic.or.ke', 'no object found'),
			'ac.ke' => array('whois.kenic.or.ke', 'no object found'),
			'co.ke' => array('whois.kenic.or.ke', 'no object found'),
			'kerryhotels' => array('whois.nic.kerryhotels', 'no match'),
			'kerrylogistics' => array('whois.nic.kerrylogistics', 'no match'),
			'kerryproperties' => array('whois.nic.kerryproperties', 'no match'),
			'kg' => array('whois.kg', 'data not found'),
			'com.kg' => array('whois.kg', 'data not found'),
			'net.kg' => array('whois.kg', 'data not found'),
			'org.kg' => array('whois.kg', 'data not found'),
			'kia' => array('whois.nic.kia', 'not found'),
			'kim' => array('whois.afilias.net', 'not found'),
			'kitchen' => array('whois.donuts.co', 'domain not found'),
			'kiwi' => array('whois.nic.kiwi', 'not found'),
			'kn' => array('whois.nic.kn', 'no object found'),
			'koeln' => array('whois.nic.koeln', 'no information was found'),
			'komatsu' => array('whois.nic.komatsu', 'not found'),
			'kosher' => array('whois.afilias-srs.net', 'not found'),
			'kr' => array('whois.kr', 'the requested domain was not found'),
			'ac.kr' => array('whois.nic.or.kr', 'domain was not found'),
			'co.kr' => array('whois.nic.or.kr', 'domain was not found'),
			'go.kr' => array('whois.nic.or.kr', 'domain was not found'),
			'ne.kr' => array('whois.nic.or.kr', 'domain was not found'),
			'nm.kr' => array('whois.nic.or.kr', 'domain was not found'),
			'or.kr' => array('whois.nic.or.kr', 'domain was not found'),
			're.kr' => array('whois.nic.or.kr', 'domain was not found'),
			'krd' => array('whois.nic.krd', 'No Data Found'),
			'kuokgroup' => array('whois.nic.kuokgroup', 'no match'),
			'ky' => array('whois.kyregistry.ky', 'is available for registration'),
			'kyoto' => array('whois.nic.kyoto', 'not found'),
			'kz' => array('whois.nic.kz', 'nothing found'),
			'la' => array('whois.nic.la', 'not found'),
			'lacaixa' => array('whois.nic.lacaixa', 'no match'),
			'lamborghini' => array('whois.afilias-srs.net', 'not found'),
			'lamer' => array('whois.afilias-srs.net', 'not found'),
			'lancaster' => array('whois.nic.lancaster', 'not found'),
			'lancia' => array('whois.afilias-srs.net', 'not found'),
			'land' => array('whois.donuts.co', 'domain not found'),
			'landrover' => array('whois.nic.landrover', 'no match'),
			'lasalle' => array('whois.afilias-srs.net', 'not found'),
			'latino' => array('whois.afilias-srs.net', 'not found'),
			'latrobe' => array('whois.nic.latrobe', 'No Data Found'),
			'law' => array('whois.nic.law', 'this domain name has not been registered'),
			'lawyer' => array('whois.nic.lawyer', 'domain not found.'),
			'lc' => array('whois.afilias-grs.info', 'not found'),
			'lds' => array('whois.afilias-srs.net', 'not found'),
			'lease' => array('whois.donuts.co', 'domain not found.'),
			'leclerc' => array('whois.nic.leclerc', 'not found'),
			'lefrak' => array('whois.nic.lefrak', 'no match'),
			'legal' => array('whois.donuts.co', 'domain not found.'),
			'lego' => array('whois.nic.lego', 'no match'),
			'lexus' => array('whois.nic.lexus', 'not found'),
			'lgbt' => array('whois.afilias.net', 'not found'),
			'li' => array('whois.nic.li', 'not have an entry'),
			'life' => array('whois.donuts.co', 'domain not found.'),
			'lifestyle' => array('whois.nic.lifestyle', 'no match'),
			'lighting' => array('whois.donuts.co', 'domain not found'),
			'like' => array('whois.nic.like', 'this domain name has not been registered'),
			'limited' => array('whois.donuts.co', 'domain not found.'),
			'limo' => array('whois.donuts.co', 'domain not found'),
			'linde' => array('whois.nic.linde', 'no match'),
			'link' => array('whois.uniregistry.net', 'is available for registration'),
			'lipsy' => array('whois.nic.lipsy', 'no match'),
			'live' => array('whois.nic.live', 'domain not found.'),
			'living' => array('whois.nic.living', 'no match'),
			'llc' => array('whois.nic.llc', 'not found'),
			'loan' => array('whois.nic.loan', 'No Data Found'),
			'loans' => array('whois.donuts.co', 'domain not found.'),
			'locker' => array('whois.afilias-srs.net', 'not found'),
			'locus' => array('whois.nic.locus', 'this domain name has not been registered'),
			'lol' => array('whois.uniregistry.net', 'is available for registration'),
			'london' => array('whois.nic.london', 'this domain name has not been registered'),
			'lotte' => array('whois.nic.lotte', 'not found'),
			'lotto' => array('whois.afilias.net', 'not found'),
			'ls' => array('whois.nic.ls', 'no entries found'),
			'lt' => array('whois.domreg.lt', 'status:\s+available'),
			'ltd' => array('whois.donuts.co', 'not found'),
			'ltda' => array('whois.afilias-srs.net', 'not found'),
			'lu' => array('whois.dns.lu', '% no such domain'),
			'lundbeck' => array('whois.nic.lundbeck', 'no match'),
			'luxe' => array('whois.nic.luxe', 'this domain name has not been registered'),
			'luxury' => array('whois.nic.luxury', 'No Data Found'),
			'lv' => array('whois.nic.lv', 'status: free'),
			'eu.lv' => array('whois.biz', 'No Data Found'),
			'ly' => array('whois.nic.ly', 'not found'),
			'ma' => array('whois.iam.net.ma', 'no object found'),
			'macys' => array('whois.nic.macys', 'no match'),
			'madrid' => array('whois.madrid.rs.corenic.net', 'no match'),
			'maison' => array('whois.donuts.co', 'domain not found'),
			'makeup' => array('whois.nic.makeup', 'no match'),
			'man' => array('whois.nic.man', 'no match'),
			'management' => array('whois.donuts.co', 'domain not found'),
			'mango' => array('whois.nic.mango', 'no matching objects found'),
			'map' => array('whois.nic.google', 'domain not found'),
			'market' => array('whois.nic.market', 'domain not found.'),
			'marketing' => array('whois.donuts.co', 'domain not found'),
			'markets' => array('whois.nic.markets', 'no match'),
			'marriott' => array('whois.afilias-srs.net', 'not found'),
			'maserati' => array('whois.afilias-srs.net', 'not found'),
			'mba' => array('whois.donuts.co', 'not found'),
			'mckinsey' => array('whois.afilias-srs.net', 'not found'),
			'md' => array('whois.nic.md', 'no match'),
			'me' => array('whois.nic.me', 'not found'),
			'med' => array('whois.nic.med', 'no match'),
			'media' => array('whois.donuts.co', 'domain not found.'),
			'meet' => array('whois.afilias.net', 'not found'),
			'melbourne' => array('whois.nic.melbourne', 'No Data Found'),
			'meme' => array('whois.nic.google', 'domain not found.'),
			'memorial' => array('whois.donuts.co', 'domain not found.'),
			'men' => array('whois.nic.men', 'No Data Found'),
			'menu' => array('whois.nic.menu', 'No Data Found'),
			'metlife' => array('whois.afilias-srs.net', 'not found'),
			'mg' => array('whois.nic.mg', 'no object found'),
			'miami' => array('whois.nic.miami', 'this domain name has not been registered'),
			'mil' => array('whois.internic.net', 'no match'),
			'mit' => array('whois.afilias-srs.net', 'not found'),
			'mitsubishi' => array('whois.nic.gmo', 'not found'),
			'mk' => array('whois.marnet.mk', '% no entries found.'),
			'ml' => array('whois.freenom.com', 'domain name not known'),
			'mls' => array('whois.nic.mls', 'not found'),
			'mma' => array('whois.nic.mma', 'not found'),
			'mn' => array('whois.afilias-grs.info', 'not found'),
			'mo' => array('whois.monic.mo', 'no match'),
			'mobi' => array('whois.afilias.net', 'not found'),
			'mobile' => array('whois.nic.mobile', 'not found'),
			'moda' => array('whois.nic.moda', 'domain not found.'),
			'moe' => array('whois.nic.moe', 'No Data Found'),
			'mom' => array('whois.uniregistry.net', 'is available for registration'),
			'monash' => array('whois.nic.monash', 'No Data Found'),
			'money' => array('whois.donuts.co', 'domain not found.'),
			'mopar' => array('whois.afilias-srs.net', 'not found'),
			'mormon' => array('whois.afilias-srs.net', 'not found'),
			'mortgage' => array('whois.nic.mortgage', 'domain not found.'),
			'moscow' => array('whois.nic.moscow', 'domain not found.'),
			'motorcycles' => array('whois.afilias-srs.net', 'not found'),
			'mov' => array('whois.nic.google', 'domain not found.'),
			'movie' => array('whois.donuts.co', 'not found'),
			'mq' => array('whois.mediaserv.net', 'no object found'),
			'mr' => array('whois.nic.mr', 'no object found'),
			'ms' => array('whois.nic.ms', 'no object found'),
			'mt' => array('whois.nic.org.mt', 'domain is not registered'),
			'mtn' => array('whois.nic.mtn', 'No Data Found'),
			'mtpc' => array('whois.nic.gmo', 'not found'),
			'mtr' => array('whois.nic.mtr', 'the domain has not been registered'),
			'mu' => array('whois.nic.mu', 'no object found'),
			'museum' => array('whois.museum', 'object does not exist'),
			'mw' => array('whois.nic.mw', 'no entries found'),
			'mz' => array('whois.nic.mz', 'no object found'),
			'na' => array('whois.na-nic.com.na', 'no object found'),
			'nab' => array('whois.nic.nab', 'no match'),
			'nagoya' => array('whois.gmoregistry.net', 'not found'),
			'name' => array('whois.nic.name', 'no match'),
			'natura' => array('whois.gtlds.nic.br', 'object does not exist'),
			'navy' => array('whois.nic.navy', 'domain not found.'),
			'nc' => array('whois.nc', 'no entries found'),
			'nec' => array('whois.nic.nec', 'not found'),
			'net' => array('whois.crsnic.net', 'No match for'),
			'netbank' => array('whois.nic.netbank', 'No Data Found'),
			'network' => array('whois.donuts.co', 'domain not found.'),
			'new' => array('whois.nic.google', 'domain not found.'),
			'newholland' => array('whois.afilias-srs.net', 'not found'),
			'news' => array('whois.nic.news', 'domain not found.'),
			'next' => array('whois.nic.next', 'no match'),
			'nextdirect' => array('whois.nic.nextdirect', 'no match'),
			'nexus' => array('whois.nic.google', 'domain not found.'),
			'nf' => array('whois.nic.nf', 'no object found'),
			'ng' => array('whois.nic.net.ng', 'no object found'),
			'ngo' => array('whois.publicinterestregistry.net', 'Domain not found'),
			'nico' => array('whois.nic.nico', 'not found'),
			'nikon' => array('whois.nic.nikon', 'no match'),
			'ninja' => array('whois.donuts.co', 'domain not found.'),
			'nissan' => array('whois.nic.gmo', 'not found'),
			'nissay' => array('whois.nic.nissay', 'no match'),
			'nl' => array('whois.domain-registry.nl', 'is free'),
			'no' => array('whois.norid.no', 'no match'),
			'nokia' => array('whois.afilias-srs.net', 'not found'),
			'norton' => array('whois.nic.norton', 'no match'),
			'now' => array('whois.nic.now', 'this domain name has not been registered'),
			'nowruz' => array('whois.agitsys.net', 'no object found'),
			'nowtv' => array('whois.afilias-srs.net', 'not found'),
			'nra' => array('whois.afilias-srs.net', 'not found'),
			'nrw' => array('whois.nic.nrw', 'no match'),
			'nu' => array('whois.iis.nu', 'not found'),
			'nyc' => array('whois.nic.nyc', 'No Data Found'),
			'nz' => array('whois.srs.net.nz', '220 available'),
			'ac.nz' => array('whois.srs.net.nz', '220 available'),
			'co.nz' => array('whois.srs.net.nz', '220 available'),
			'cri.nz' => array('whois.srs.net.nz', '220 available'),
			'geek.nz' => array('whois.srs.net.nz', '220 available'),
			'gen.nz' => array('whois.srs.net.nz', '220 available'),
			'govt.nz' => array('whois.srs.net.nz', '220 available'),
			'iwi.nz' => array('whois.srs.net.nz', '220 available'),
			'health.nz' => array('whois.srs.net.nz', '220 available'),
			'kiwi.nz' => array('whois.srs.net.nz', '220 available'),
			'maori.nz' => array('whois.srs.net.nz', '220 available'),
			'mil.nz' => array('whois.srs.net.nz', '220 available'),
			'net.nz' => array('whois.srs.net.nz', '220 available'),
			'org.nz' => array('whois.srs.net.nz', '220 available'),
			'parliament.nz' => array('whois.srs.net.nz', '220 available'),
			'school.nz' => array('whois.srs.net.nz', '220 available'),
			'obi' => array('whois.nic.obi', 'no match'),
			'okinawa' => array('whois.nic.okinawa', 'domain not found'),
			'olayan' => array('whois.nic.olayan', 'No Data Found'),
			'olayangroup' => array('whois.nic.olayangroup', 'No Data Found'),
			'ollo' => array('whois.afilias-srs.net', 'not found'),
			'om' => array('whois.registry.om', 'No Data Found'),
			'omega' => array('whois.nic.omega', 'no match'),
			'one' => array('whois.nic.one', 'No Data Found'),
			'ong' => array('whois.publicinterestregistry.net', 'Domain not found'),
			'onl' => array('whois.afilias-srs.net', 'not found'),
			'oracle' => array('whois.nic.oracle', 'no match'),
			'orange' => array('whois.nic.orange', 'no match'),
			'org' => array('whois.publicinterestregistry.net', 'Domain not found'),
			'organic' => array('whois.afilias.net', 'not found'),
			'origins' => array('whois.afilias-srs.net', 'not found'),
			'osaka' => array('whois.nic.osaka', 'No Data Found'),
			'ott' => array('whois.afilias-srs.net', 'not found'),
			'ovh' => array('whois.nic.ovh', 'not found'),
			'page' => array('whois.nic.google', 'not found'),
			'panasonic' => array('whois.nic.gmo', 'not found'),
			'paris' => array('whois.nic.paris', 'not found'),
			'pars' => array('whois.agitsys.net', 'no object found'),
			'partners' => array('whois.donuts.co', 'domain not found.'),
			'parts' => array('whois.donuts.co', 'domain not found.'),
			'party' => array('whois.nic.party', 'No Data Found'),
			'pccw' => array('whois.afilias-srs.net', 'not found'),
			'pe' => array('kero.yachay.pe', 'no object found'),
			'pet' => array('whois.afilias.net', 'not found'),
			'pf' => array('whois.registry.pf', 'domain unknown'),
			'philips' => array('whois.nic.philips', 'No Data Found'),
			'phone' => array('whois.nic.phone', 'not found'),
			'photo' => array('whois.uniregistry.net', 'is available for registration'),
			'photography' => array('whois.donuts.co', 'domain not found'),
			'photos' => array('whois.donuts.co', 'domain not found'),
			'physio' => array('whois.nic.physio', 'No Data Found'),
			'pics' => array('whois.uniregistry.net', 'is available for registration'),
			'pictures' => array('whois.donuts.co', 'domain not found.'),
			'ping' => array('whois.nic.ping', 'No Data Found'),
			'pink' => array('whois.afilias.net', 'not found'),
			'pioneer' => array('whois.nic.gmo', 'not found'),
			'pizza' => array('whois.donuts.co', 'domain not found.'),
			'pl' => array('whois.dns.pl', 'no information available'),
			'agro.pl' => array('whois.dns.pl', 'no information available'),
			'aid.pl' => array('whois.dns.pl', 'no information available'),
			'atm.pl' => array('whois.dns.pl', 'no information available'),
			'auto.pl' => array('whois.dns.pl', 'no information available'),
			'biz.pl' => array('whois.dns.pl', 'no information available'),
			'co.pl' => array('whois.co.pl', 'not found'),
			'com.pl' => array('whois.dns.pl', 'no information available'),
			'edu.pl' => array('whois.dns.pl', 'no information available'),
			'gmina.pl' => array('whois.dns.pl', 'no information available'),
			'gsm.pl' => array('whois.dns.pl', 'no information available'),
			'info.pl' => array('whois.dns.pl', 'no information available'),
			'mail.pl' => array('whois.dns.pl', 'no information available'),
			'media.pl' => array('whois.dns.pl', 'no information available'),
			'miasta.pl' => array('whois.dns.pl', 'no information available'),
			'mil.pl' => array('whois.dns.pl', 'no information available'),
			'net.pl' => array('whois.dns.pl', 'no information available'),
			'nom.pl' => array('whois.dns.pl', 'no information available'),
			'org.pl' => array('whois.dns.pl', 'no information available'),
			'pc.pl' => array('whois.dns.pl', 'no information available'),
			'priv.pl' => array('whois.dns.pl', 'no information available'),
			'realestate.pl' => array('whois.dns.pl', 'no information available'),
			'rel.pl' => array('whois.dns.pl', 'no information available'),
			'shop.pl' => array('whois.dns.pl', 'no information available'),
			'sklep.pl' => array('whois.dns.pl', 'no information available'),
			'sos.pl' => array('whois.dns.pl', 'no information available'),
			'targi.pl' => array('whois.dns.pl', 'no information available'),
			'tm.pl' => array('whois.dns.pl', 'no information available'),
			'tourism.pl' => array('whois.dns.pl', 'no information available'),
			'travel.pl' => array('whois.dns.pl', 'no information available'),
			'turystyka.pl' => array('whois.dns.pl', 'no information available'),
			'place' => array('whois.donuts.co', 'domain not found.'),
			'play' => array('whois.nic.google', 'not found'),
			'playstation' => array('whois.nic.playstation', 'not found'),
			'plumbing' => array('whois.donuts.co', 'domain not found'),
			'plus' => array('whois.donuts.co', 'not found'),
			'pm' => array('whois.nic.fr', 'no entries found'),
			'pnc' => array('whois.afilias-srs.net', 'not found'),
			'poker' => array('whois.afilias.net', 'not found'),
			'politie' => array('whois.nic.politie', 'status: free'),
			'porn' => array('whois.afilias-srs.net', 'not found'),
			'post' => array('whois.dotpostregistry.net', 'not found'),
			'pr' => array('whois.nic.pr', 'not found'),
			'pro' => array('whois.afilias.net', 'not found'),
			'prod' => array('whois.nic.google', 'domain not found.'),
			'productions' => array('whois.donuts.co', 'domain not found.'),
			'prof' => array('whois.nic.google', 'domain not found.'),
			'progressive' => array('whois.afilias-srs.net', 'not found'),
			'promo' => array('whois.afilias.net', 'not found'),
			'properties' => array('whois.donuts.co', 'domain not found.'),
			'property' => array('whois.uniregistry.net', 'is available for registration'),
			'ps' => array('whois.pnina.ps', 'no object found'),
			'pt' => array('whois.dns.pt', 'no match'),
			'com.pt' => array('whois.dns.pt', 'no match'),
			'edu.pt' => array('whois.dns.pt', 'no match'),
			'pub' => array('whois.nic.pub', 'domain not found.'),
			'pwc' => array('whois.afilias-srs.net', 'not found'),
			'qa' => array('whois.registry.qa', 'No Data Found'),
			'qpon' => array('whois.nic.qpon', 'No Data Found'),
			'quebec' => array('whois.nic.quebec', 'no match'),
			'quest' => array('whois.nic.quest', 'No Data Found'),
			'racing' => array('whois.nic.racing', 'No Data Found'),
			'radio' => array('whois.nic.radio', 'no match'),
			're' => array('whois.nic.fr', 'no entries found'),
			'realestate' => array('whois.nic.realestate', 'no match'),
			'recipes' => array('whois.donuts.co', 'domain not found'),
			'red' => array('whois.afilias.net', 'not found'),
			'redstone' => array('whois.afilias-srs.net', 'not found'),
			'redumbrella' => array('whois.afilias-srs.net', 'not found'),
			'rehab' => array('whois.nic.rehab', 'domain not found.'),
			'reise' => array('whois.nic.reise', 'not found'),
			'reisen' => array('whois.donuts.co', 'domain not found.'),
			'rentals' => array('whois.donuts.co', 'domain not found.'),
			'repair' => array('whois.donuts.co', 'domain not found'),
			'report' => array('whois.donuts.co', 'domain not found.'),
			'republican' => array('whois.nic.republican', 'domain not found.'),
			'restaurant' => array('whois.donuts.co', 'domain not found.'),
			'review' => array('whois.nic.review', 'No Data Found'),
			'reviews' => array('whois.nic.reviews', 'domain not found.'),
			'rexroth' => array('whois.nic.rexroth', 'no match'),
			'rich' => array('whois.afilias-srs.net', 'not found'),
			'richardli' => array('whois.afilias-srs.net', 'not found'),
			'ricoh' => array('whois.nic.ricoh', 'not found'),
			'rio' => array('whois.gtlds.nic.br', 'object does not exist'),
			'rip' => array('whois.nic.rip', 'domain not found.'),
			'ro' => array('whois.rotld.ro', 'no entries found'),
			'arts.ro' => array('whois.rotld.ro', 'no entries found'),
			'com.ro' => array('whois.rotld.ro', 'no entries found'),
			'firm.ro' => array('whois.rotld.ro', 'no entries found'),
			'info.ro' => array('whois.rotld.ro', 'no entries found'),
			'nom.ro' => array('whois.rotld.ro', 'no entries found'),
			'nt.ro' => array('whois.rotld.ro', 'no entries found'),
			'org.ro' => array('whois.rotld.ro', 'no entries found'),
			'rec.ro' => array('whois.rotld.ro', 'no entries found'),
			'store.ro' => array('whois.rotld.ro', 'no entries found'),
			'tm.ro' => array('whois.rotld.ro', 'no entries found'),
			'www.ro' => array('whois.rotld.ro', 'no entries found'),
			'rocks' => array('whois.nic.rocks', 'domain not found.'),
			'rodeo' => array('whois.nic.rodeo', 'this domain name has not been registered'),
			'rogers' => array('whois.afilias-srs.net', 'not found'),
			'room' => array('whois.nic.room', 'this domain name has not been registered'),
			'rs' => array('whois.rnids.rs', 'is not registered'),
			'co.rs' => array('whois.rnids.rs', '%error:103'),
			'edu.rs' => array('whois.rnids.rs', '%error:103'),
			'in.rs' => array('whois.rnids.rs', '%error:103'),
			'org.rs' => array('whois.rnids.rs', '%error:103'),
			'rsvp' => array('whois.nic.google', 'domain not found.'),
			'ru' => array('whois.ripn.net', 'no entries found'),
			'com.ru' => array('whois.ripn.net', 'no entries found'),
			'edu.ru' => array('whois.informika.ru', 'is free.'),
			'msk.ru' => array('whois.nic.ru', 'no entries found'),
			'net.ru' => array('whois.ripn.net', 'no entries found'),
			'org.ru' => array('whois.nic.ru', 'no entries found'),
			'pp.ru' => array('whois.nic.ru', 'no entries found'),
			'spb.ru' => array('whois.nic.ru', 'no entries found'),
			'ruhr' => array('whois.nic.ruhr', 'no match'),
			'run' => array('whois.donuts.co', 'not found'),
			'rw' => array('whois.ricta.org.rw', 'no object found'),
			'rwe' => array('whois.nic.rwe', 'no match'),
			'ryukyu' => array('whois.nic.ryukyu', 'domain not found'),
			'sa' => array('whois.nic.net.sa', 'no match'),
			'sale' => array('whois.nic.sale', 'domain not found.'),
			'salon' => array('whois.donuts.co', 'not found'),
			'samsclub' => array('whois.nic.samsclub', 'no match'),
			'samsung' => array('whois.nic.samsung', 'domain not found'),
			'sandvik' => array('whois.nic.sandvik', 'No Data Found'),
			'sandvikcoromant' => array('whois.nic.sandvikcoromant', 'No Data Found'),
			'sanofi' => array('whois.nic.sanofi', 'no match'),
			'sap' => array('whois.nic.sap', 'no match'),
			'sarl' => array('whois.donuts.co', 'domain not found.'),
			'saxo' => array('whois.nic.saxo', 'No Data Found'),
			'sb' => array('whois.nic.net.sb', 'no object found'),
			'sbi' => array('whois.afilias-srs.net', 'not found'),
			'sbs' => array('whois.nic.sbs', 'no match'),
			'sc' => array('whois.afilias-grs.info', 'not found'),
			'sca' => array('whois.nic.sca', 'no match'),
			'scb' => array('whois.nic.scb', 'not found'),
			'schaeffler' => array('whois.afilias-srs.net', 'not found'),
			'schmidt' => array('whois.nic.schmidt', 'No Data Found'),
			'scholarships' => array('whois.afilias-srs.net', 'not found'),
			'school' => array('whois.donuts.co', 'domain not found.'),
			'schule' => array('whois.donuts.co', 'domain not found.'),
			'science' => array('whois.nic.science', 'No Data Found'),
			'scot' => array('whois.nic.scot', 'no matching objects found'),
			'se' => array('whois.iis.se', 'not found'),
			'search' => array('whois.nic.google', 'domain not found'),
			'seat' => array('whois.nic.seat', 'no match'),
			'secure' => array('whois.nic.secure', 'this domain name has not been registered'),
			'seek' => array('whois.nic.seek', 'No Data Found'),
			'select' => array('whois.nic.select', 'No Data Found'),
			'services' => array('whois.donuts.co', 'domain not found.'),
			'ses' => array('whois.nic.ses', 'no match'),
			'seven' => array('whois.nic.seven', 'No Data Found'),
			'sew' => array('whois.afilias-srs.net', 'not found'),
			'sex' => array('whois.afilias-srs.net', 'not found'),
			'sexy' => array('whois.uniregistry.net', 'is available for registration'),
			'sg' => array('whois.sgnic.sg', 'not found'),
			'com.sg' => array('whois.sgnic.sg', 'domain not found'),
			'edu.sg' => array('whois.sgnic.sg', 'domain not found'),
			'gov.sg' => array('whois.sgnic.sg', 'domain not found'),
			'net.sg' => array('whois.sgnic.sg', 'domain not found'),
			'org.sg' => array('whois.sgnic.sg', 'domain not found'),
			'sh' => array('whois.nic.sh', 'not found'),
			'shangrila' => array('whois.nic.shangrila', 'no match'),
			'sharp' => array('whois.nic.gmo', 'not found'),
			'shaw' => array('whois.afilias-srs.net', 'not found'),
			'shell' => array('whois.nic.shell', 'no match'),
			'shia' => array('whois.agitsys.net', 'no object found'),
			'shiksha' => array('whois.afilias.net', 'not found'),
			'shoes' => array('whois.donuts.co', 'domain not found'),
			'shop' => array('whois.nic.shop', 'domain not found'),
			'shopping' => array('whois.donuts.co', 'not found'),
			'show' => array('whois.donuts.co', 'not found'),
			'showtime' => array('whois.afilias-srs.net', 'not found'),
			'shriram' => array('whois.afilias-srs.net', 'not found'),
			'si' => array('whois.arnes.si', 'no entries found'),
			'sina' => array('whois.afilias-srs.net', 'not found'),
			'singles' => array('whois.donuts.co', 'domain not found'),
			'sk' => array('whois.sk-nic.sk', 'not found'),
			'ski' => array('whois.nic.ski', 'not found'),
			'skin' => array('whois.nic.skin', 'no match'),
			'sky' => array('whois.nic.sky', 'no match'),
			'sl' => array('whois.nic.sl', 'no object found'),
			'sling' => array('whois.afilias-srs.net', 'not found'),
			'sm' => array('whois.nic.sm', 'no entries found'),
			'sn' => array('whois.nic.sn', 'no object found'),
			'sncf' => array('whois.nic.sncf', 'not found'),
			'so' => array('whois.nic.so', 'no object found'),
			'soccer' => array('whois.donuts.co', 'not found'),
			'social' => array('whois.nic.social', 'domain not found.'),
			'softbank' => array('whois.nic.softbank', 'not found'),
			'software' => array('whois.nic.software', 'domain not found.'),
			'sohu' => array('whois.gtld.knet.cn', 'object does not exist'),
			'solar' => array('whois.donuts.co', 'domain not found'),
			'solutions' => array('whois.donuts.co', 'domain not found'),
			'sony' => array('whois.nic.sony', 'not found'),
			'soy' => array('whois.nic.google', 'domain not found.'),
			'spa' => array('whois.afilias-srs.net', 'not found'),
			'sport' => array('whois.nic.sport', 'no matching objects found'),
			'srl' => array('whois.afilias-srs.net', 'not found'),
			'srt' => array('whois.afilias-srs.net', 'not found'),
			'st' => array('whois.nic.st', 'no entries found'),
			'stada' => array('whois.afilias-srs.net', 'not found'),
			'star' => array('whois.afilias-srs.net', 'not found'),
			'statebank' => array('whois.afilias-srs.net', 'not found'),
			'stockholm' => array('whois.afilias-srs.net', 'not found'),
			'su' => array('whois.tcinet.ru', 'no entries found'),
			'ss' => array('whois.nic.ss', 'no object found'),
			'biz.ss' => array('whois.nic.ss', 'no object found'),
			'com.ss' => array('whois.nic.ss', 'no object found'),
			'me.ss' => array('whois.nic.ss', 'no object found'),
			'net.ss' => array('whois.nic.ss', 'no object found'),
			'studio' => array('whois.nic.studio', 'domain not found.'),
			'study' => array('whois.nic.study', 'No Data Found'),
			'stream' => array('whois.nic.stream', 'No Data Found'),
			'style' => array('whois.donuts.co', 'domain not found.'),
			'su' => array('whois.ripn.net', 'no entries found'),
			'sochi.su' => array('whois.nic.ru', 'no entries found'),
			'sucks' => array('whois.nic.sucks', 'No Data Found'),
			'supplies' => array('whois.donuts.co', 'domain not found.'),
			'supply' => array('whois.donuts.co', 'domain not found.'),
			'support' => array('whois.donuts.co', 'domain not found'),
			'surf' => array('whois.nic.surf', 'this domain name has not been registered'),
			'surgery' => array('whois.donuts.co', 'domain not found.'),
			'swatch' => array('whois.nic.swatch', 'no match'),
			'swiss' => array('whois.nic.swiss', 'no match'),
			'sx' => array('whois.sx', 'no match'),
			'sy' => array('whois.tld.sy', 'no object found'),
			'sydney' => array('whois.nic.sydney', 'No Data Found'),
			'systems' => array('whois.donuts.co', 'domain not found'),
			'tab' => array('whois.nic.tab', 'No Data Found'),
			'talk' => array('whois.nic.talk', 'this domain name has not been registered'),
			'taipei' => array('whois.nic.taipei', 'No Data Found'),
			'tatamotors' => array('whois.nic.tatamotors', 'no match'),
			'tatar' => array('whois.nic.tatar', 'object does not exist'),
			'tattoo' => array('whois.uniregistry.net', 'is available for registration'),
			'tax' => array('whois.donuts.co', 'domain not found.'),
			'taxi' => array('whois.donuts.co', 'not found'),
			'tc' => array('whois.nic.tc', 'no object found'),
			'tci' => array('whois.agitsys.net', 'no object found'),
			'td' => array('whois.nic.td', 'no object found'),
			'tdk' => array('whois.nic.tdk', 'No Data Found'),
			'team' => array('whois.donuts.co', 'not found'),
			'technology' => array('whois.donuts.co', 'domain not found'),
			'tel' => array('whois.nic.tel', 'No Data Found'),
			'temasek' => array('whois.afilias-srs.net', 'not found'),
			'tennis' => array('whois.donuts.co', 'domain not found.'),
			'teva' => array('whois.nic.teva', 'No Data Found'),
			'tf' => array('whois.nic.tf', 'no entries found'),
			'tg' => array('whois.nic.tg', 'no object found'),
			'th' => array('whois.thnic.co.th', 'no match'),
			'ac.th' => array('whois.thnic.net', 'no match'),
			'co.th' => array('whois.thnic.net', 'no match'),
			'go.th' => array('whois.thnic.net', 'no match'),
			'in.th' => array('whois.thnic.net', 'no match'),
			'mi.th' => array('whois.thnic.net', 'no match'),
			'net.th' => array('whois.thnic.net', 'no match'),
			'or.th' => array('whois.thnic.net', 'no match'),
			'thd' => array('whois.afilias-srs.net', 'not found'),
			'theater' => array('whois.donuts.co', 'not found'),
			'tiaa' => array('whois.nic.tiaa', 'no match'),
			'tienda' => array('whois.donuts.co', 'domain not found.'),
			'tiffany' => array('whois.nic.tiffany', 'no match'),
			'tiffay' => array('whois.nic.tiffany', 'no match'),
			'tips' => array('whois.donuts.co', 'domain not found'),
			'tires' => array('whois.donuts.co', 'domain not found.'),
			'tirol' => array('whois.nic.tirol', 'no information was found'),
			'tk' => array('whois.freenom.com', 'domain name not known'),
			'tl' => array('whois.nic.tl', 'no object found'),
			'tm' => array('whois.nic.tm', 'is available'),
			'tn' => array('whois.ati.tn', 'no object found!'),
			'to' => array('whois.tonic.to', 'no match'),
			'today' => array('whois.donuts.co', 'domain not found'),
			'tokyo' => array('whois.nic.tokyo', 'not found'),
			'tools' => array('whois.donuts.co', 'domain not found.'),
			'top' => array('whois.nic.top', 'object does not exist'),
			'toray' => array('whois.nic.toray', 'not found'),
			'toshiba' => array('whois.nic.toshiba', 'not found'),
			'total' => array('whois.nic.total', 'not found'),
			'tours' => array('whois.donuts.co', 'not found'),
			'town' => array('whois.donuts.co', 'domain not found.'),
			'toyota' => array('whois.nic.toyota', 'not found'),
			'toys' => array('whois.donuts.co', 'domain not found.'),
			'trade' => array('whois.nic.trade', 'No Data Found'),
			'trading' => array('whois.nic.trading', 'no match'),
			'training' => array('whois.donuts.co', 'domain not found'),
			'travel' => array('whois.nic.travel', 'No Data Found'),
			'travelchannel' => array('whois.nic.travelchannel', 'no match'),
			'travelers' => array('whois.afilias-srs.net', 'not found'),
			'travelersinsurance' => array('whois.afilias-srs.net', 'not found'),
			'trust' => array('whois.nic.trust', 'No Data Found'),
			'trv' => array('whois.afilias-srs.net', 'not found'),
			'tube' => array('whois.nic.tube', 'No Data Found'),
			'tv' => array('tvwhois.verisign-grs.com', 'no match'),
			'tvs' => array('whois.afilias-srs.net', 'not found'),
			'tw' => array('whois.twnic.net', 'no found'),
			'com.tw' => array('whois.twnic.net', 'no found'),
			'net.tw' => array('whois.twnic.net', 'no found'),
			'org.tw' => array('whois.twnic.net', 'no found'),
			'tz' => array('whois.tznic.or.tz', '% no entries found.'),
			'ua' => array('whois.ua', 'no entries found'),
			'biz.ua' => array('whois.biz.ua', 'no entries found'),
			'co.ua' => array('whois.co.ua', 'no entries found'),
			'com.ua' => array('whois.com.ua', 'no entries found for'),
			'dn.ua' => array('whois.dn.ua', 'no entries found'),
			'in.ua' => array('whois.in.ua', 'domain name does not exist'),
			'kh.ua' => array('whois.net.ua', 'no entries found'),
			'kiev.ua' => array('whois.kiev.ua', 'no entries found'),
			'lg.ua' => array('whois.net.ua', 'no entries found'),
			'lviv.ua' => array('whois.lviv.ua', 'no object found'),
			'net.ua' => array('whois.net.ua', 'no entries found'),
			'pp.ua' => array('whois.pp.ua', 'no entries found'),
			'ubank' => array('whois.nic.ubank', 'no match'),
			'ubs' => array('whois.nic.ubs', 'no match'),
			'uconnect' => array('whois.afilias-srs.net', 'not found'),
			'ug' => array('whois.co.ug', 'no entries found'),
			'uk' => array('whois.nic.uk', 'No match'),
			'ac.uk' => array('whois.ja.net', 'no such domain'),
			'co.uk' => array('whois.nic.uk', 'No match'),
			'gov.uk' => array('whois.ja.net', 'No such domain'),
			'ltd.uk' => array('whois.nic.uk', 'No match'),
			'me.uk' => array('whois.nic.uk', 'No match'),
			'net.uk' => array('whois.nic.uk', 'No match'),
			'org.uk' => array('whois.nic.uk', 'No match'),
			'plc.uk' => array('whois.nic.uk', 'No match'),
			'university' => array('whois.donuts.co', 'domain not found.'),
			'uno' => array('whois.nic.uno', 'No Data Found'),
			'uol' => array('whois.gtlds.nic.br', 'object does not exist'),
			'ups' => array('whois.afilias-srs.net', 'not found'),
			'us' => array('whois.nic.us', 'No Data Found'),
			'fed.us' => array('whois.nic.gov', 'no match'),
			'uy' => array('whois.nic.org.uy', 'no match'),
			'uz' => array('whois.cctld.uz', 'not found'),
			'vacations' => array('whois.donuts.co', 'domain not found.'),
			'vana' => array('whois.nic.vana', 'no match'),
			'vanguard' => array('whois.nic.vanguard', 'no match'),
			'vc' => array('whois2.afilias-grs.net', 'not found'),
			'vegas' => array('whois.afilias-srs.net', 'not found'),
			'ventures' => array('whois.donuts.co', 'not found'),
			'verisign' => array('whois.nic.verisign', 'no match'),
			'versicherung' => array('whois.nic.versicherung', 'object does not exist'),
			'vet' => array('whois.nic.vet', 'domain not found.'),
			'viajes' => array('whois.donuts.co', 'domain not found'),
			'video' => array('whois.nic.video', 'domain not found.'),
			'vig' => array('whois.afilias-srs.net', 'not found'),
			'viking' => array('whois.afilias-srs.net', 'not found'),
			'villas' => array('whois.donuts.co', 'domain not found.'),
			'vin' => array('whois.donuts.co', 'not found'),
			'vip' => array('whois.nic.vip', 'this domain name has not been registered'),
			'virgin' => array('whois.nic.virgin', 'No Data Found'),
			'visa' => array('whois.nic.visa', 'no match'),
			'vision' => array('whois.donuts.co', 'domain not found.'),
			'vlaanderen' => array('whois.nic.vlaanderen', 'domain not found.'),
			'vodka' => array('whois.nic.vodka', 'this domain name has not been registered'),
			'volkswagen' => array('whois.afilias-srs.net', 'not found'),
			'volvo' => array('whois.nic.volvo', 'no match'),
			'vote' => array('whois.afilias.net', 'not found'),
			'voting' => array('whois.nic.voting', 'No Data Found'),
			'voto' => array('whois.afilias.net', 'not found'),
			'voyage' => array('whois.donuts.co', 'domain not found'),
			'vu' => array('whois.dnrs.vu', 'No Data Found'),
			'wales' => array('whois.nic.wales', 'this domain name has not been registered'),
			'walmart' => array('whois.nic.walmart', 'no match'),
			'walter' => array('whois.nic.walter', 'No Data Found'),
			'wang' => array('whois.gtld.knet.cn', 'object does not exist'),
			'watch' => array('whois.donuts.co', 'domain not found.'),
			'webcam' => array('whois.nic.webcam', 'No Data Found'),
			'weber' => array('whois.nic.weber', 'no match'),
			'wed' => array('whois.nic.wed', 'this domain name has not been registered'),
			'wedding' => array('whois.nic.wedding', 'this domain name has not been registered'),
			'weibo' => array('whois.nic.weibo', 'not found'),
			'wf' => array('whois.nic.fr', 'no entries found'),
			'whoswho' => array('whois.nic.whoswho', 'No Data Found'),
			'wien' => array('whois.nic.wien', 'available'),
			'win' => array('whois.nic.win', 'No Data Found'),
			'wine' => array('whois.donuts.co', 'not found'),
			'wolterskluwer' => array('whois.afilias-srs.net', 'not found'),
			'woodside' => array('whois.nic.woodside', 'No Data Found'),
			'work' => array('whois.nic.work', 'this domain name has not been registered'),
			'works' => array('whois.donuts.co', 'domain not found.'),
			'world' => array('whois.donuts.co', 'domain not found.'),
			'ws' => array('whois.website.ws', 'object does not exist'),
			'wtc' => array('whois.nic.wtc', 'No Data Found'),
			'wtf' => array('whois.donuts.co', 'domain not found.'),
			'xerox' => array('whois.nic.xerox', 'no match'),
			'xfinity' => array('whois.nic.xfinity', 'this domain name has not been registered'),
			'xin' => array('whois.nic.xin', 'not found'),
			'xxx' => array('whois.nic.xxx', 'not found'),
			'yachts' => array('whois.afilias-srs.net', 'not found'),
			'yodobashi' => array('whois.nic.gmo', 'not found'),
			'yoga' => array('whois.nic.yoga', 'this domain name has not been registered'),
			'yokohama' => array('whois.nic.yokohama', 'domain not found'),
			'you' => array('whois.nic.you', 'this domain name has not been registered'),
			'youtube' => array('whois.nic.google', 'domain not found.'),
			'yt' => array('whois.nic.fr', 'no entries found'),
			'co.za' => array('co-whois.registry.net.za', 'available'),
			'net.za' => array('net-whois.registry.net.za', 'available'),
			'org.za' => array('org-whois.registry.net.za', 'available'),
			'web.za' => array('web-whois.registry.net.za', 'available'),
			'zara' => array('whois.afilias-srs.net', 'not found'),
			'zip' => array('whois.nic.google', 'domain not found.'),
			'zm' => array('whois.nic.zm', 'domain status: no object found'),
			'zone' => array('whois.donuts.co', 'domain not found.'),
		);
	
		// gethostbyname returns the same string if it cant find the domain,
		// we do a further check to see if it is a false positive
		// get the TLD of the domain
			$tld = $this->get_tld($domain);

			// If an entry for the TLD exists in the whois array
			if (isset($whois_arr[$tld][0])) {
				// set the hostname for the whois server
				$whois_server = $whois_arr[$tld][0];

				// set the "domain not found" string
				$bad_string = $whois_arr[$tld][1];
			} else {
				// TODO: REFACTOR THIS
				// TLD is not in the whois array, die
				//throw new Exception("WHOIS server not found for that TLD");
				return '2';
			}

			$status = $this->checkDomainNameAvailabilty($domain,$whois_server,$bad_string);

			return $status;
}
	

	/**
	 * Extracts the TLD from a domain, supports URLS with "www." at the beginning.
	 * @param string $domain The domain that will get it's TLD extracted
	 * @return string The TLD for $domain
	 */

	public function get_tld ($domain) {
		$split = explode('.', $domain);

		if(count($split) === 0) {
			throw new Exception('Invalid domain extension');
			
		}
		return end($split);
	}

	public function checkDomainNameAvailabilty($domain_name, $whois_server, $find_text){
 
    // Open a socket connection to the whois server
    $con = fsockopen($whois_server, 43);
    if (!$con) return false;
 
    // Send the requested domain name
    fputs($con, $domain_name."\r\n");
 
    // Read and store the server response
    $response = " :";
    while(!feof($con))
        $response .= fgets($con,128); 
 
    // Close the connection
    fclose($con);
 
    // Check the Whois server response
    if (strpos($response, $find_text))
	return '1';
    else
    return '0';
	}
}