from logging import getLogger

from defence360agent.contracts.config import MyImunifyConfig
from defence360agent.rpc_tools.lookup import RootEndpoints, bind

from ...control import (
    disable_native_feature_management,
    enable_native_feature_management,
    is_native_feature_management_enabled,
    is_native_feature_management_supported,
)

logger = getLogger(__name__)

__all__ = []


class FeatureManagementNativeEndpoints(RootEndpoints):
    def __init__(self, sink):
        super().__init__(sink)

    @bind("feature-management", "native", "status")
    async def feature_management_native_status(self):
        if not MyImunifyConfig.ENABLED:
            supported = bool(await is_native_feature_management_supported())
            enabled = bool(await is_native_feature_management_enabled())
        else:
            supported = False
            enabled = False

        return {
            "items": {
                "supported": supported,
                "enabled": enabled,
            }
        }

    @bind("feature-management", "native", "enable")
    async def feature_management_native_enable(self):
        await enable_native_feature_management()

    @bind("feature-management", "native", "disable")
    async def feature_management_native_disable(self):
        disabled = await disable_native_feature_management()
        if disabled:
            return {
                "items": "Imunify360 package extensions have been removed from all packages"  # noqa: E501
            }
