#!/usr/bin/bash

LOG="/usr/share/lve/modlscapi/logs/lsapi_patch.log"
RES=$(cat "/usr/local/cpanel/Cpanel/WebServer/Supported/apache.pm" | grep "lsapi")

if [ -z "$RES" ]; then

    current_path=$(pwd)
    common_path_of_cpanel="/usr/share/lve/modlscapi/tars/"
    cd "$common_path_of_cpanel" || exit

    if [ -e "apache_pm.patch" ]; then

        cd /usr/local/cpanel/Cpanel/WebServer/Supported || exit
        patch -N -i $common_path_of_cpanel/apache_pm.patch

        if [ $? != 0 ]; then
            echo "$(date +%Y-%m-%d_%H:%M) - Error applying patch..." >> "$LOG"
            cd "$current_path" || exit
            exit 1
        else
            echo "$(date +%Y-%m-%d_%H:%M) - Patch was applied correctly..." >> "$LOG"
            cd "$current_path" || exit
            exit 0
        fi
    else
        echo "$(date +%Y-%m-%d_%H:%M) - Cannot find apache_pm.patch..." >> "$LOG"
        cd "$current_path" || exit
        exit 1
    fi
else
    echo "$(date +%Y-%m-%d_%H:%M) - Already patched..." >> "$LOG"
    exit 0
fi



