<?php

/******************************
 * cmd_buildmatchingphp.php
 *
 * Options:
 * 		-f force build even it is matched
 * 		-v verify version and config options, no actual build
 * 		default no option: build the matching php if there is difference.
 *
 * Command line tool to build Apache matching PHP.
 * This requires that existing php has been successfully built by whm EasyApache tool.
 * You can make this as part of your automated server installation script after EasyApache build done.
 *
 ******************************/

ini_set('max_execution_time', 7200);

require_once('WhmMod_LiteSpeed_BuildPHP.php');

define ('PHP_AP_LOC', '/usr/local/bin/php');	// Apache PHP location
define ('LSWS_HOME', '/usr/local/lsws');

define( 'CGI_DIR', '/usr/local/cpanel/whostmgr/docroot/cgi/lsws' );
define( 'WGET_TEMP', '/usr/src/lsws' );
$path_to_bld = "";

$buildtool = new WhmMod_LiteSpeed_BuildPHP();

$next = $buildtool->PrecheckPHPVersion(PHP_AP_LOC, $msg);
echo "$msg \n";

// return 0: same, 1 different; 2 error stop;
$do_build = FALSE;

if ($next == 2) {
	echo "Please make sure PHP exists, you can specify a different location by editing variable definition PHP_AP_LOC \n";
}
elseif (isset($argv[1]) && $argv[1] == '-v') {
	echo "Verify only - Exit!\n";
}
elseif ($next == 0) {
	if (isset($argv[1]) && $argv[1] == '-f') {
		echo "Config option is same, will do force rebuild matching php";
		$do_build = TRUE;
	}
	else {
		echo "No need to rebuild. Aborted! If you want to do force rebuid, add parameter -f \n";
	}
}
else { // next == 1
	$do_build = TRUE;
}

if ((isset($argv[1])) && ($argv[1] != '-f') && ($argv[1] != '-v')) {
    $path_to_bld = trim($argv[1]);
}

if (!$do_build)
	exit;

echo "Next will build lsphp using the same configuration as Apache's php.
	This will download the source code and build php binary. The whole process may take more than 10 minutes, please be patient.\n";

$curdir = getcwd();
if ($curdir != CGI_DIR) {
	echo "change current directory to " . CGI_DIR . "\n";
	chdir(CGI_DIR);
}

$result = $buildtool->GenerateBuildScript(PHP_AP_LOC, $path_to_bld);
if (isset($result['error'])) {
	echo "{$result['error']} \n Aborted!\n";
	return false;
}

$build_script = $result['file'];

echo "build script generated at $build_script \n";

system($build_script);

