<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Features_Block_05 extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_features_block_05';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Features Block 05', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-table-of-contents';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__( 'Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
			'img_two_elementor_id',
			[
				'label' => esc_html__( 'Left Side Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);

		$this->add_control(
            'heading1',
            [
                'label'     => esc_html__( 'Heading Line-1', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'heading2',
            [
                'label'     => esc_html__( 'Heading Line-2', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text',
            [
                'label'     => esc_html__( 'Text Below Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );		
		
		$this->add_control(
            'features_one',
            [
                'label'     => esc_html__( 'Bullet Points', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('Start each point on new line','maxhost'),
                'default' => '',
            ]
        );
		
		
		
		$this->add_control(
            'price_title',
            [
                'label'     => esc_html__( 'Price Title', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price Title (e.g. Starts at)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'price',
            [
                'label'     => esc_html__( 'Price Amount', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price Amount with Currency (e.g. $99)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'price_duration',
            [
                'label'     => esc_html__( 'Price Duration', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Price Duration (e.g. /month)', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id',
			[
				'label' => esc_html__( 'Right Side Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__('Attach the right side image (image width should not be more than 270px) of this block', 'maxhost'),
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->add_control(
            'active',
            [
                'label'     => esc_html__('Want to remove the top margin?', 'maxhost'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'description' => '',
				'return_value' => 'false',
				'default' => 'false',
				'label_block' => true,
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

		$args['img_one_elementor_id'] =  $settings['img_one_elementor_id'];
		$args['img_two_elementor_id'] =  $settings['img_two_elementor_id'];
		$args['heading1'] =  $settings['heading1'];
		$args['heading2'] =  $settings['heading2'];
		$args['text'] =  $settings['text'];
		$args['features_one'] =  $settings['features_one'];
		$args['price_title'] =  $settings['price_title'];
		$args['price'] =  $settings['price'];
		$args['price_duration'] =  $settings['price_duration'];
		$args['active'] =  $settings['active'];
       
        if( function_exists( 'maxhost_features_block_five_shortcode' ) ) {
            echo maxhost_features_block_five_shortcode( $args );
        }

    }

}