"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
import logging

from defence360agent.rpc_tools import ValidationError
from defence360agent.rpc_tools.lookup import RootEndpoints, bind
from defence360agent.utils import Scope
from imav.malwarelib.subsys import pure_ftpd
from defence360agent.subsys.panels import hosting_panel


logger = logging.getLogger(__name__)


class PureFTPDEndpoints(RootEndpoints):
    SCOPE = Scope.IM360

    @bind("pure-ftpd", "enable")
    async def enable_pure_ftpd(self):
        if not pure_ftpd.detect():
            raise ValidationError("pure-ftpd is not installed")

        running = await pure_ftpd.uploadscript_status()
        thirdparty_uploadscript = pure_ftpd.thirdparty_uploadscript()

        if thirdparty_uploadscript is not None:
            raise ValidationError(
                "Third-party pure-uploadscript detected: {},"
                " disabling pure-ftpd scans".format(thirdparty_uploadscript)
            )

        panel = hosting_panel.HostingPanel()
        if not running:
            logger.info("Enabling pure-ftpd service")
            await pure_ftpd.uploadscript_enable()
        if not pure_ftpd.scan_in_config_enabled(panel):
            logger.info("Enabling upload script in pure-ftpd configs")
            await pure_ftpd.enable_scan_in_config(panel)
