<?php

$salt = __salt('[[admin_pass]]');
$methodAndSalt = '$2y$' . $salt;
	
$resp = crypt('[[admin_pass]]', $methodAndSalt);
echo '<update_pass>'.$resp.'</update_pass>';
echo '<update_salt>'.$salt.'</update_salt>';
@unlink('update_pass.php');



// Create the Salt
function __salt($password, $member = null) {
	$generator = new __RandomGenerator();
	return sprintf('%02d', 10) . '$' . substr($generator->generateHash('sha1'), 0, 22);
}

// Class to create the salt
class __RandomGenerator {

	/**
	 * Note: Returned values are not guaranteed to be crypto-safe,
	 * depending on the used retrieval method.
	 * 
	 * @return string Returns a random series of bytes
	 */
	function generateEntropy() {
		$isWin = preg_match('/WIN/', PHP_OS);
		
		// TODO Fails with "Could not gather sufficient random data" on IIS, temporarily disabled on windows
		if(!$isWin) {
			if(function_exists('mcrypt_create_iv')) {
				$e = mcrypt_create_iv(64, MCRYPT_DEV_URANDOM);
				if($e !== false) return $e;
			}
		}

		// Fall back to SSL methods - may slow down execution by a few ms
		if (function_exists('openssl_random_pseudo_bytes')) {
			$e = openssl_random_pseudo_bytes(64, $strong);
			// Only return if strong algorithm was used
			if($strong) return $e;
		}

		// Read from the unix random number generator
		if(!$isWin && !ini_get('open_basedir') && is_readable('/dev/urandom') && ($h = fopen('/dev/urandom', 'rb'))) {
			$e = fread($h, 64);
			fclose($h);
			return $e;
		}

		// Warning: Both methods below are considered weak

		// try to read from the windows RNG
		if($isWin && class_exists('COM')) {
			try {
				$comObj = new COM('CAPICOM.Utilities.1');
				$e = base64_decode($comObj->GetRandom(64, 0));
				return $e;
			} catch (Exception $ex) {
			}
		}

		// Fallback to good old mt_rand()
		return uniqid(mt_rand(), true);
	}
	
	/**
	 * Generates a hash suitable for manual session identifiers, CSRF tokens, etc.
	 * 
	 * @param String $algorithm Any identifier listed in hash_algos() (Default: whirlpool)
	 *  If possible, choose a slow algorithm which complicates brute force attacks.
	 * @return String Returned length will depend on the used $algorithm
	 */
	function generateHash($algorithm = 'whirlpool') {
		return hash($algorithm, $this->generateEntropy());
	}
	
}
?>