<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Bullet_Points extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_bullet_points';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Bullet Points', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-table-of-contents';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__( 'Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'section_style',
            [
                'label'     => esc_html__('Choose Style', 'maxhost'),
                'type' => \Elementor\Controls_Manager::SELECT,
				'options'   => [
                    '' => esc_html__('Choose Style', 'maxhost'),
                    'list-group' => esc_html__('Style 01', 'maxhost'),
                    'listitems' => esc_html__('Style 02', 'maxhost'),
                ],
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'bullets',
            [
                'label'     => esc_html__( 'Bullet Points', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('Start each point on new line','maxhost'),
                'default' => '',
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

        $args['section_style'] =  $settings['section_style'];
		$args['bullets'] =  $settings['bullets'];

       
        if( function_exists( 'maxhost_bullet_points_one_shortcode' ) ) {
            echo maxhost_bullet_points_one_shortcode( $args );
        }

    }

}