<?php
function fthemes_customizer_settings( $wp_customize ) {
    $wp_customize->add_section(
        'ft_theme_token_section',
        array(
            'title'      => 'Fluent-Themes',
            'priority'   => 30,
        )
    );
	
	$wp_customize->add_setting(
        'ft_token_field',
        array(
            'default'      => '',
            'type'   => 'option',
            'capability' => 'manage_options',
        )
    );

    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'ft_token_field',
        array(
            'label'      => 'Fluent-Themes Item Activation',
            'description' => 'Activation Token Number',
            'settings'   => 'ft_token_field',
            'priority'   => 10,
            'section'    => 'ft_theme_token_section',
            'type'       => 'text',
        )
    ) );
	
	
}
add_action( 'customize_register', 'fthemes_customizer_settings' );

#-----------------------------------------------------------------
# Theme Shortcodes
#-----------------------------------------------------------------

function fthemes_is_validation_compatible() {
		include( 'inc/elementor/class-fthemes-rand-numbers.php' );
		if((null !== get_option('ft_token_field')) && !empty(get_option('ft_token_field'))) {
			$validation_compatible = get_option('ft_token_field');
		} else { 
			$validation_compatible = '';
		}
		$output = false;
		
		if (in_array($validation_compatible, $rand_number_list)) {
			$output = true;
		} else {
			$output = false;
		}
		return $output;
}

if ( did_action( 'elementor/loaded' ) ) {
	require_once 'inc/elementor/elementor.php';
}

function fthemes_activate_plugin() {
  if ( fthemes_is_validation_compatible() ) {
	require_once 'inc/wpbakery/shortcodes.php';

	#-----------------------------------------------------------------
	# Custom Post Type for Megamenu Item
	#-----------------------------------------------------------------

	require_once 'maxhost-post-type.php';
	require_once 'domain-checker/maxhost-dc.php';
  } else {
	return false;
  }
}