<?php
/*
Plugin Name: The Maxhost Extensions
Plugin URI: https://fluentthemes.com
Description: Extensions for Maxhost Wordpress Theme. Supplied as a separate plugin so that the users do not find empty shortcodes on changing the theme.
Version: 3.9.1
Author: Fluent-Themes
Author URI: https://themeforest.net/user/fluent-themes
Tested up to: 6.6
*/

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! defined( 'MAXHOST_PLUGIN_PATH' ) ) {
	define( 'MAXHOST_PLUGIN_PATH',              dirname( __FILE__ ));
}

//Load Modules
require_once 'modules/core-functions.php';

#-----------------------------------------------------------------
# Load Custom Widgets
#-----------------------------------------------------------------
if ( fthemes_is_validation_compatible() ) {
	add_action( 'plugins_loaded', 'ft_init_plugin', 10 );
}

function the_maxhost_extensions(){
$active_theme = wp_get_theme(); // gets the current theme
if ( 'Maxhost' == $active_theme->name || 'Maxhost' == $active_theme->parent_theme ) {
//Check if Maxhost theme is active or not 
require_once 'modules/widgets.php';
}
}

function ft_init_plugin(){
	the_maxhost_extensions();
	fthemes_activate_plugin();
}