<?php
/**
 * Template part for displaying slider banner
 *
 * @package Pharmacy Shop
 */

$pharmacy_shop_static_image = get_stylesheet_directory_uri() . '/assets/images/post-img.png';

// Get the selected page ID from the Customizer
$pharmacy_shop_selected_page_id = get_theme_mod('pharmacy_shop_static_blog_2');

if (!empty($pharmacy_shop_selected_page_id) && get_post_status($pharmacy_shop_selected_page_id)) {

    // Query the selected page
    $pharmacy_shop_query = new WP_Query(array(
        'post_type'      => 'page',
        'p'              => absint($pharmacy_shop_selected_page_id),
        'posts_per_page' => 1,
    ));

    if ($pharmacy_shop_query->have_posts()) : ?>
        <div class="slide-banner">
            <div class="banner-1 position-relative">
                <?php while ($pharmacy_shop_query->have_posts()) : $pharmacy_shop_query->the_post(); ?>
                    <div class="slide-item">
                        <?php
                        $pharmacy_shop_image_url = has_post_thumbnail()
                            ? get_the_post_thumbnail_url(get_the_ID(), 'full')
                            : $pharmacy_shop_static_image;
                        ?>
                        <img src="<?php echo esc_url($pharmacy_shop_image_url); ?>" alt="<?php the_title_attribute(); ?>" />

                        <div class="blog-info-1">
                            <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                            <p><?php echo wp_kses_post(wp_trim_words(get_the_content(), 10)); ?></p>
                            <div class="more-btn">
                                <a href="<?php the_permalink(); ?>">
                                    <i class="fas fa-shopping-basket"></i> <?php esc_html_e('Shop Now', 'pharmacy-shop'); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endwhile;
                wp_reset_postdata(); ?>
            </div>
        </div>
    <?php else : ?>
        <div class="no-postfound"><?php esc_html_e('No page found.', 'pharmacy-shop'); ?></div>
    <?php endif;
}
?>
