PK     V_[@o      Y  wp-content/plugins/wordpress-importer/php-toolkit/DataLiberation/vendor-patched/README.mdnu [        # Vendor Patches

The libraries in this directory have been downgraded to PHP 7.2 compatibility using Rector
and some manual fixes.
PK     V_[=
    s  wp-content/plugins/wordpress-importer/php-toolkit/DataLiberation/vendor-patched/symfony/polyfill-php80/PhpToken.phpnu [        <?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Polyfill\Php80;

use function in_array;
use function is_string;
use function ord;
use function strlen;

use const T_COMMENT;
use const T_DOC_COMMENT;
use const T_OPEN_TAG;
use const T_WHITESPACE;

/**
 * @author Fedonyuk Anton <info@ensostudio.ru>
 *
 * @internal
 */
class PhpToken {
	/**
	 * @var int
	 */
	public $id;
	/**
	 * @var string
	 */
	public $text;
	/**
	 * @var int
	 */
	public $line;
	/**
	 * @var int
	 */
	public $pos;

	public function __construct( int $id, string $text, int $line = - 1, int $position = - 1 ) {
		$this->id   = $id;
		$this->text = $text;
		$this->line = $line;
		$this->pos  = $position;
	}

	public function getTokenName(): ?string {
		if ( 'UNKNOWN' === $name = token_name( $this->id ) ) {
			$name = strlen( $this->text ) > 1 || ord( $this->text ) < 32 ? null : $this->text;
		}

		return $name;
	}

	/**
	 * @param  int|string|array  $kind
	 */
	public function is( $kind ): bool {
		foreach ( (array) $kind as $value ) {
			if ( in_array( $value, [ $this->id, $this->text ], true ) ) {
				return true;
			}
		}

		return false;
	}

	public function isIgnorable(): bool {
		return in_array( $this->id, [ T_WHITESPACE, T_COMMENT, T_DOC_COMMENT, T_OPEN_TAG ], true );
	}

	public function __toString(): string {
		return (string) $this->text;
	}

	/**
	 * @return static[]
	 */
	public static function tokenize( string $code, int $flags = 0 ): array {
		$line     = 1;
		$position = 0;
		$tokens   = token_get_all( $code, $flags );
		foreach ( $tokens as $index => $token ) {
			if ( is_string( $token ) ) {
				$id   = ord( $token );
				$text = $token;
			} else {
				[ $id, $text, $line ] = $token;
			}
			$tokens[ $index ] = new static( $id, $text, $line, $position );
			$position         += strlen( $text );
		}

		return $tokens;
	}
}
PK     V_[q    p  wp-content/plugins/wordpress-importer/php-toolkit/DataLiberation/vendor-patched/symfony/polyfill-php80/Php80.phpnu [        <?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Polyfill\Php80;

use __PHP_Incomplete_Class;
use TypeError;

use function get_class;
use function is_array;
use function is_bool;
use function is_float;
use function is_int;
use function is_object;
use function is_resource;
use function is_string;
use function strlen;

use const PREG_BACKTRACK_LIMIT_ERROR;
use const PREG_BAD_UTF8_ERROR;
use const PREG_BAD_UTF8_OFFSET_ERROR;
use const PREG_INTERNAL_ERROR;
use const PREG_JIT_STACKLIMIT_ERROR;
use const PREG_NO_ERROR;
use const PREG_RECURSION_LIMIT_ERROR;

/**
 * @author Ion Bazan <ion.bazan@gmail.com>
 * @author Nico Oelgart <nicoswd@gmail.com>
 * @author Nicolas Grekas <p@tchwork.com>
 *
 * @internal
 */
final class Php80 {
	public static function fdiv( float $dividend, float $divisor ): float {
		return @( $dividend / $divisor );
	}

	public static function get_debug_type( $value ): string {
		switch ( true ) {
			case null === $value:
				return 'null';
			case is_bool( $value ):
				return 'bool';
			case is_string( $value ):
				return 'string';
			case is_array( $value ):
				return 'array';
			case is_int( $value ):
				return 'int';
			case is_float( $value ):
				return 'float';
			case is_object( $value ):
				break;
			case $value instanceof __PHP_Incomplete_Class:
				return '__PHP_Incomplete_Class';
			default:
				if ( null === $type = @get_resource_type( $value ) ) {
					return 'unknown';
				}

				if ( 'Unknown' === $type ) {
					$type = 'closed';
				}

				return "resource ($type)";
		}

		$class = get_class( $value );

		if ( false === strpos( $class, '@' ) ) {
			return $class;
		}

		return ( get_parent_class( $class ) ?: key( class_implements( $class ) ) ?: 'class' ) . '@anonymous';
	}

	public static function get_resource_id( $res ): int {
		if ( ! is_resource( $res ) && null === @get_resource_type( $res ) ) {
			throw new TypeError( sprintf( 'Argument 1 passed to get_resource_id() must be of the type resource, %s given',
				get_debug_type( $res ) ) );
		}

		return (int) $res;
	}

	public static function preg_last_error_msg(): string {
		switch ( preg_last_error() ) {
			case PREG_INTERNAL_ERROR:
				return 'Internal error';
			case PREG_BAD_UTF8_ERROR:
				return 'Malformed UTF-8 characters, possibly incorrectly encoded';
			case PREG_BAD_UTF8_OFFSET_ERROR:
				return 'The offset did not correspond to the beginning of a valid UTF-8 code point';
			case PREG_BACKTRACK_LIMIT_ERROR:
				return 'Backtrack limit exhausted';
			case PREG_RECURSION_LIMIT_ERROR:
				return 'Recursion limit exhausted';
			case PREG_JIT_STACKLIMIT_ERROR:
				return 'JIT stack limit exhausted';
			case PREG_NO_ERROR:
				return 'No error';
			default:
				return 'Unknown error';
		}
	}

	public static function str_contains( string $haystack, string $needle ): bool {
		return '' === $needle || false !== strpos( $haystack, $needle );
	}

	public static function str_starts_with( string $haystack, string $needle ): bool {
		return 0 === strncmp( $haystack, $needle, strlen( $needle ) );
	}

	public static function str_ends_with( string $haystack, string $needle ): bool {
		if ( '' === $needle || $needle === $haystack ) {
			return true;
		}

		if ( '' === $haystack ) {
			return false;
		}

		$needleLength = strlen( $needle );

		return $needleLength <= strlen( $haystack ) && 0 === substr_compare( $haystack, $needle, - $needleLength );
	}
}
PK     V_[	V#R  R  t  wp-content/plugins/wordpress-importer/php-toolkit/DataLiberation/vendor-patched/symfony/polyfill-php80/composer.jsonnu [        {
	"name": "symfony/polyfill-php80",
	"type": "library",
	"description": "Symfony polyfill backporting some PHP 8.0+ features to lower PHP versions",
	"keywords": [
		"polyfill",
		"shim",
		"compatibility",
		"portable"
	],
	"homepage": "https://symfony.com",
	"license": "MIT",
	"authors": [
		{
			"name": "Ion Bazan",
			"email": "ion.bazan@gmail.com"
		},
		{
			"name": "Nicolas Grekas",
			"email": "p@tchwork.com"
		},
		{
			"name": "Symfony Community",
			"homepage": "https://symfony.com/contributors"
		}
	],
	"require": {
		"php": ">=7.2"
	},
	"autoload": {
		"psr-4": {
			"Symfony\\Polyfill\\Php80\\": ""
		},
		"files": [
			"bootstrap.php"
		],
		"classmap": [
			"Resources/stubs"
		]
	},
	"minimum-stability": "dev",
	"extra": {
		"thanks": {
			"name": "symfony/polyfill",
			"url": "https://github.com/symfony/polyfill"
		}
	}
}
PK     V_[좒,z  z  p  wp-content/plugins/wordpress-importer/php-toolkit/DataLiberation/vendor-patched/symfony/polyfill-php80/README.mdnu [        # Symfony Polyfill / Php80

This component provides features added to PHP 8.0 core:

- [`Stringable`](https://php.net/stringable) interface
- [`fdiv`](https://php.net/fdiv)
- [`ValueError`](https://php.net/valueerror) class
- [`UnhandledMatchError`](https://php.net/unhandledmatcherror) class
- `FILTER_VALIDATE_BOOL` constant
- [`get_debug_type`](https://php.net/get_debug_type)
- [`PhpToken`](https://php.net/phptoken) class
- [`preg_last_error_msg`](https://php.net/preg_last_error_msg)
- [`str_contains`](https://php.net/str_contains)
- [`str_starts_with`](https://php.net/str_starts_with)
- [`str_ends_with`](https://php.net/str_ends_with)
- [`get_resource_id`](https://php.net/get_resource_id)

More information can be found in the
[main Polyfill README](https://github.com/symfony/polyfill/blob/main/README.md).

# License

This library is released under the [MIT license](LICENSE).
PK     V_[I:  :  t  wp-content/plugins/wordpress-importer/php-toolkit/DataLiberation/vendor-patched/symfony/polyfill-php80/bootstrap.phpnu [        <?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Symfony\Polyfill\Php80 as p;

if ( PHP_VERSION_ID >= 80000 ) {
	return;
}

if ( ! defined( 'FILTER_VALIDATE_BOOL' ) && defined( 'FILTER_VALIDATE_BOOLEAN' ) ) {
	define( 'FILTER_VALIDATE_BOOL', FILTER_VALIDATE_BOOLEAN );
}

if ( ! function_exists( 'fdiv' ) ) {
	function fdiv( float $num1, float $num2 ): float {
		return p\Php80::fdiv( $num1, $num2 );
	}
}
if ( ! function_exists( 'preg_last_error_msg' ) ) {
	function preg_last_error_msg(): string {
		return p\Php80::preg_last_error_msg();
	}
}
if ( ! function_exists( 'str_contains' ) ) {
	function str_contains( ?string $haystack, ?string $needle ): bool {
		return p\Php80::str_contains( $haystack ?? '', $needle ?? '' );
	}
}
if ( ! function_exists( 'str_starts_with' ) ) {
	function str_starts_with( ?string $haystack, ?string $needle ): bool {
		return p\Php80::str_starts_with( $haystack ?? '', $needle ?? '' );
	}
}
if ( ! function_exists( 'str_ends_with' ) ) {
	function str_ends_with( ?string $haystack, ?string $needle ): bool {
		return p\Php80::str_ends_with( $haystack ?? '', $needle ?? '' );
	}
}
if ( ! function_exists( 'get_debug_type' ) ) {
	function get_debug_type( $value ): string {
		return p\Php80::get_debug_type( $value );
	}
}
if ( ! function_exists( 'get_resource_id' ) ) {
	function get_resource_id( $resource ): int {
		return p\Php80::get_resource_id( $resource );
	}
}
PK     V_[̫p  p    wp-content/plugins/wordpress-importer/php-toolkit/DataLiberation/vendor-patched/symfony/polyfill-php80/Resources/stubs/PhpToken.phpnu [        <?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

if ( PHP_VERSION_ID < 80000 && extension_loaded( 'tokenizer' ) ) {
	class PhpToken extends Symfony\Polyfill\Php80\PhpToken {
	}
}
PK     V_[>  >    wp-content/plugins/wordpress-importer/php-toolkit/DataLiberation/vendor-patched/symfony/polyfill-php80/Resources/stubs/UnhandledMatchError.phpnu [        <?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

if ( PHP_VERSION_ID < 80000 ) {
	class UnhandledMatchError extends Error {
	}
}
PK     V_[4NLk  k    wp-content/plugins/wordpress-importer/php-toolkit/DataLiberation/vendor-patched/symfony/polyfill-php80/Resources/stubs/Stringable.phpnu [        <?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distribu